<?php

namespace EnumType;

/**
 * This class stands for JP_CommissionType EnumType
 * @subpackage Enumerations
 */
class JP_CommissionType
{
    /**
     * Constant for value 'Fixed'
     * @return string 'Fixed'
     */
    const VALUE_FIXED = 'Fixed';
    /**
     * Constant for value 'Percent'
     * @return string 'Percent'
     */
    const VALUE_PERCENT = 'Percent';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_FIXED
     * @uses self::VALUE_PERCENT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_FIXED,
            self::VALUE_PERCENT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
