<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_TransferContentRQ StructType
 * @subpackage Structs
 */
class JP_TransferContentRQ extends AbstractStructBase
{
    /**
     * The Login
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_Login
     */
    public $Login;
    /**
     * The TransferContentList
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_TransferSimpleContent
     */
    public $TransferContentList;
    /**
     * The RestrictedOptions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_RestrictedOptions
     */
    public $RestrictedOptions;
    /**
     * The Version
     * @var string
     */
    public $Version;
    /**
     * The Context
     * @var string
     */
    public $Context;
    /**
     * The Language
     * @var string
     */
    public $Language;
    /**
     * The TimeStamp
     * @var string
     */
    public $TimeStamp;
    /**
     * Constructor method for JP_TransferContentRQ
     * @uses JP_TransferContentRQ::setLogin()
     * @uses JP_TransferContentRQ::setTransferContentList()
     * @uses JP_TransferContentRQ::setRestrictedOptions()
     * @uses JP_TransferContentRQ::setVersion()
     * @uses JP_TransferContentRQ::setContext()
     * @uses JP_TransferContentRQ::setLanguage()
     * @uses JP_TransferContentRQ::setTimeStamp()
     * @param \StructType\JP_Login $login
     * @param \ArrayType\ArrayOfJP_TransferSimpleContent $transferContentList
     * @param \StructType\JP_RestrictedOptions $restrictedOptions
     * @param string $version
     * @param string $context
     * @param string $language
     * @param string $timeStamp
     */
    public function __construct(\StructType\JP_Login $login = null, \ArrayType\ArrayOfJP_TransferSimpleContent $transferContentList = null, \StructType\JP_RestrictedOptions $restrictedOptions = null, $version = null, $context = null, $language = null, $timeStamp = null)
    {
        $this
            ->setLogin($login)
            ->setTransferContentList($transferContentList)
            ->setRestrictedOptions($restrictedOptions)
            ->setVersion($version)
            ->setContext($context)
            ->setLanguage($language)
            ->setTimeStamp($timeStamp);
    }
    /**
     * Get Login value
     * @return \StructType\JP_Login|null
     */
    public function getLogin()
    {
        return $this->Login;
    }
    /**
     * Set Login value
     * @param \StructType\JP_Login $login
     * @return \StructType\JP_TransferContentRQ
     */
    public function setLogin(\StructType\JP_Login $login = null)
    {
        $this->Login = $login;
        return $this;
    }
    /**
     * Get TransferContentList value
     * @return \ArrayType\ArrayOfJP_TransferSimpleContent|null
     */
    public function getTransferContentList()
    {
        return $this->TransferContentList;
    }
    /**
     * Set TransferContentList value
     * @param \ArrayType\ArrayOfJP_TransferSimpleContent $transferContentList
     * @return \StructType\JP_TransferContentRQ
     */
    public function setTransferContentList(\ArrayType\ArrayOfJP_TransferSimpleContent $transferContentList = null)
    {
        $this->TransferContentList = $transferContentList;
        return $this;
    }
    /**
     * Get RestrictedOptions value
     * @return \StructType\JP_RestrictedOptions|null
     */
    public function getRestrictedOptions()
    {
        return $this->RestrictedOptions;
    }
    /**
     * Set RestrictedOptions value
     * @param \StructType\JP_RestrictedOptions $restrictedOptions
     * @return \StructType\JP_TransferContentRQ
     */
    public function setRestrictedOptions(\StructType\JP_RestrictedOptions $restrictedOptions = null)
    {
        $this->RestrictedOptions = $restrictedOptions;
        return $this;
    }
    /**
     * Get Version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param string $version
     * @return \StructType\JP_TransferContentRQ
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->Version = $version;
        return $this;
    }
    /**
     * Get Context value
     * @return string|null
     */
    public function getContext()
    {
        return $this->Context;
    }
    /**
     * Set Context value
     * @param string $context
     * @return \StructType\JP_TransferContentRQ
     */
    public function setContext($context = null)
    {
        // validation for constraint: string
        if (!is_null($context) && !is_string($context)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($context, true), gettype($context)), __LINE__);
        }
        $this->Context = $context;
        return $this;
    }
    /**
     * Get Language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->Language;
    }
    /**
     * Set Language value
     * @param string $language
     * @return \StructType\JP_TransferContentRQ
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($language, true), gettype($language)), __LINE__);
        }
        $this->Language = $language;
        return $this;
    }
    /**
     * Get TimeStamp value
     * @return string|null
     */
    public function getTimeStamp()
    {
        return $this->TimeStamp;
    }
    /**
     * Set TimeStamp value
     * @param string $timeStamp
     * @return \StructType\JP_TransferContentRQ
     */
    public function setTimeStamp($timeStamp = null)
    {
        // validation for constraint: string
        if (!is_null($timeStamp) && !is_string($timeStamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timeStamp, true), gettype($timeStamp)), __LINE__);
        }
        $this->TimeStamp = $timeStamp;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_TransferContentRQ
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
