<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_SupplementRelPax StructType
 * @subpackage Structs
 */
class JP_SupplementRelPax extends AbstractStructBase
{
    /**
     * The IdPax
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $IdPax;
    /**
     * The RatePlanCode
     * @var string
     */
    public $RatePlanCode;
    /**
     * Constructor method for JP_SupplementRelPax
     * @uses JP_SupplementRelPax::setIdPax()
     * @uses JP_SupplementRelPax::setRatePlanCode()
     * @param int $idPax
     * @param string $ratePlanCode
     */
    public function __construct($idPax = null, $ratePlanCode = null)
    {
        $this
            ->setIdPax($idPax)
            ->setRatePlanCode($ratePlanCode);
    }
    /**
     * Get IdPax value
     * @return int
     */
    public function getIdPax()
    {
        return $this->IdPax;
    }
    /**
     * Set IdPax value
     * @param int $idPax
     * @return \StructType\JP_SupplementRelPax
     */
    public function setIdPax($idPax = null)
    {
        // validation for constraint: int
        if (!is_null($idPax) && !(is_int($idPax) || ctype_digit($idPax))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idPax, true), gettype($idPax)), __LINE__);
        }
        $this->IdPax = $idPax;
        return $this;
    }
    /**
     * Get RatePlanCode value
     * @return string|null
     */
    public function getRatePlanCode()
    {
        return $this->RatePlanCode;
    }
    /**
     * Set RatePlanCode value
     * @param string $ratePlanCode
     * @return \StructType\JP_SupplementRelPax
     */
    public function setRatePlanCode($ratePlanCode = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanCode) && !is_string($ratePlanCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratePlanCode, true), gettype($ratePlanCode)), __LINE__);
        }
        $this->RatePlanCode = $ratePlanCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_SupplementRelPax
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
