<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_RoomList StructType
 * @subpackage Structs
 */
class JP_RoomList extends AbstractStructBase
{
    /**
     * The TotalRecords
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $TotalRecords;
    /**
     * The Room
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_RoomInfo[]
     */
    public $Room;
    /**
     * Constructor method for JP_RoomList
     * @uses JP_RoomList::setTotalRecords()
     * @uses JP_RoomList::setRoom()
     * @param int $totalRecords
     * @param \StructType\JP_RoomInfo[] $room
     */
    public function __construct($totalRecords = null, array $room = array())
    {
        $this
            ->setTotalRecords($totalRecords)
            ->setRoom($room);
    }
    /**
     * Get TotalRecords value
     * @return int
     */
    public function getTotalRecords()
    {
        return $this->TotalRecords;
    }
    /**
     * Set TotalRecords value
     * @param int $totalRecords
     * @return \StructType\JP_RoomList
     */
    public function setTotalRecords($totalRecords = null)
    {
        // validation for constraint: int
        if (!is_null($totalRecords) && !(is_int($totalRecords) || ctype_digit($totalRecords))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalRecords, true), gettype($totalRecords)), __LINE__);
        }
        $this->TotalRecords = $totalRecords;
        return $this;
    }
    /**
     * Get Room value
     * @return \StructType\JP_RoomInfo[]|null
     */
    public function getRoom()
    {
        return $this->Room;
    }
    /**
     * This method is responsible for validating the values passed to the setRoom method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRoom method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRoomForArrayConstraintsFromSetRoom(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $jP_RoomListRoomItem) {
            // validation for constraint: itemType
            if (!$jP_RoomListRoomItem instanceof \StructType\JP_RoomInfo) {
                $invalidValues[] = is_object($jP_RoomListRoomItem) ? get_class($jP_RoomListRoomItem) : sprintf('%s(%s)', gettype($jP_RoomListRoomItem), var_export($jP_RoomListRoomItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Room property can only contain items of type \StructType\JP_RoomInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Room value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_RoomInfo[] $room
     * @return \StructType\JP_RoomList
     */
    public function setRoom(array $room = array())
    {
        // validation for constraint: array
        if ('' !== ($roomArrayErrorMessage = self::validateRoomForArrayConstraintsFromSetRoom($room))) {
            throw new \InvalidArgumentException($roomArrayErrorMessage, __LINE__);
        }
        $this->Room = $room;
        return $this;
    }
    /**
     * Add item to Room value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_RoomInfo $item
     * @return \StructType\JP_RoomList
     */
    public function addToRoom(\StructType\JP_RoomInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_RoomInfo) {
            throw new \InvalidArgumentException(sprintf('The Room property can only contain items of type \StructType\JP_RoomInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Room[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_RoomList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
