<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_RestrictedOptions StructType
 * @subpackage Structs
 */
class JP_RestrictedOptions extends AbstractStructBase
{
    /**
     * The RestrictedOption
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\JP_RestrictedOption[]
     */
    public $RestrictedOption;
    /**
     * The Context
     * @var string
     */
    public $Context;
    /**
     * The SecurityCode
     * @var string
     */
    public $SecurityCode;
    /**
     * Constructor method for JP_RestrictedOptions
     * @uses JP_RestrictedOptions::setRestrictedOption()
     * @uses JP_RestrictedOptions::setContext()
     * @uses JP_RestrictedOptions::setSecurityCode()
     * @param \StructType\JP_RestrictedOption[] $restrictedOption
     * @param string $context
     * @param string $securityCode
     */
    public function __construct(array $restrictedOption = array(), $context = null, $securityCode = null)
    {
        $this
            ->setRestrictedOption($restrictedOption)
            ->setContext($context)
            ->setSecurityCode($securityCode);
    }
    /**
     * Get RestrictedOption value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\JP_RestrictedOption[]|null
     */
    public function getRestrictedOption()
    {
        return isset($this->RestrictedOption) ? $this->RestrictedOption : null;
    }
    /**
     * This method is responsible for validating the values passed to the setRestrictedOption method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRestrictedOption method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRestrictedOptionForArrayConstraintsFromSetRestrictedOption(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $jP_RestrictedOptionsRestrictedOptionItem) {
            // validation for constraint: itemType
            if (!$jP_RestrictedOptionsRestrictedOptionItem instanceof \StructType\JP_RestrictedOption) {
                $invalidValues[] = is_object($jP_RestrictedOptionsRestrictedOptionItem) ? get_class($jP_RestrictedOptionsRestrictedOptionItem) : sprintf('%s(%s)', gettype($jP_RestrictedOptionsRestrictedOptionItem), var_export($jP_RestrictedOptionsRestrictedOptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RestrictedOption property can only contain items of type \StructType\JP_RestrictedOption, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RestrictedOption value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\JP_RestrictedOption[] $restrictedOption
     * @return \StructType\JP_RestrictedOptions
     */
    public function setRestrictedOption(array $restrictedOption = array())
    {
        // validation for constraint: array
        if ('' !== ($restrictedOptionArrayErrorMessage = self::validateRestrictedOptionForArrayConstraintsFromSetRestrictedOption($restrictedOption))) {
            throw new \InvalidArgumentException($restrictedOptionArrayErrorMessage, __LINE__);
        }
        if (is_null($restrictedOption) || (is_array($restrictedOption) && empty($restrictedOption))) {
            unset($this->RestrictedOption);
        } else {
            $this->RestrictedOption = $restrictedOption;
        }
        return $this;
    }
    /**
     * Add item to RestrictedOption value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_RestrictedOption $item
     * @return \StructType\JP_RestrictedOptions
     */
    public function addToRestrictedOption(\StructType\JP_RestrictedOption $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_RestrictedOption) {
            throw new \InvalidArgumentException(sprintf('The RestrictedOption property can only contain items of type \StructType\JP_RestrictedOption, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RestrictedOption[] = $item;
        return $this;
    }
    /**
     * Get Context value
     * @return string|null
     */
    public function getContext()
    {
        return $this->Context;
    }
    /**
     * Set Context value
     * @param string $context
     * @return \StructType\JP_RestrictedOptions
     */
    public function setContext($context = null)
    {
        // validation for constraint: string
        if (!is_null($context) && !is_string($context)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($context, true), gettype($context)), __LINE__);
        }
        $this->Context = $context;
        return $this;
    }
    /**
     * Get SecurityCode value
     * @return string|null
     */
    public function getSecurityCode()
    {
        return $this->SecurityCode;
    }
    /**
     * Set SecurityCode value
     * @param string $securityCode
     * @return \StructType\JP_RestrictedOptions
     */
    public function setSecurityCode($securityCode = null)
    {
        // validation for constraint: string
        if (!is_null($securityCode) && !is_string($securityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($securityCode, true), gettype($securityCode)), __LINE__);
        }
        $this->SecurityCode = $securityCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_RestrictedOptions
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
