<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_RequiredField StructType
 * @subpackage Structs
 */
class JP_RequiredField extends AbstractStructBase
{
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Value
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Value;
    /**
     * The Values
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_RequiredFieldValue
     */
    public $Values;
    /**
     * The Type
     * @var string
     */
    public $Type;
    /**
     * The Mandatory
     * @var bool
     */
    public $Mandatory;
    /**
     * Constructor method for JP_RequiredField
     * @uses JP_RequiredField::setName()
     * @uses JP_RequiredField::setValue()
     * @uses JP_RequiredField::setValues()
     * @uses JP_RequiredField::setType()
     * @uses JP_RequiredField::setMandatory()
     * @param string $name
     * @param string $value
     * @param \ArrayType\ArrayOfJP_RequiredFieldValue $values
     * @param string $type
     * @param bool $mandatory
     */
    public function __construct($name = null, $value = null, \ArrayType\ArrayOfJP_RequiredFieldValue $values = null, $type = null, $mandatory = null)
    {
        $this
            ->setName($name)
            ->setValue($value)
            ->setValues($values)
            ->setType($type)
            ->setMandatory($mandatory);
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\JP_RequiredField
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Value value
     * @return string|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param string $value
     * @return \StructType\JP_RequiredField
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        $this->Value = $value;
        return $this;
    }
    /**
     * Get Values value
     * @return \ArrayType\ArrayOfJP_RequiredFieldValue|null
     */
    public function getValues()
    {
        return $this->Values;
    }
    /**
     * Set Values value
     * @param \ArrayType\ArrayOfJP_RequiredFieldValue $values
     * @return \StructType\JP_RequiredField
     */
    public function setValues(\ArrayType\ArrayOfJP_RequiredFieldValue $values = null)
    {
        $this->Values = $values;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \EnumType\JP_RequiredFieldType::valueIsValid()
     * @uses \EnumType\JP_RequiredFieldType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\JP_RequiredField
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JP_RequiredFieldType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JP_RequiredFieldType', is_array($type) ? implode(', ', $type) : var_export($type, true), implode(', ', \EnumType\JP_RequiredFieldType::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Mandatory value
     * @return bool|null
     */
    public function getMandatory()
    {
        return $this->Mandatory;
    }
    /**
     * Set Mandatory value
     * @param bool $mandatory
     * @return \StructType\JP_RequiredField
     */
    public function setMandatory($mandatory = null)
    {
        // validation for constraint: boolean
        if (!is_null($mandatory) && !is_bool($mandatory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($mandatory, true), gettype($mandatory)), __LINE__);
        }
        $this->Mandatory = $mandatory;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_RequiredField
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
