<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_PackageBookingRules StructType
 * @subpackage Structs
 */
class JP_PackageBookingRules extends AbstractStructBase
{
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Status;
    /**
     * The Start
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Start;
    /**
     * The End
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $End;
    /**
     * The DestinationZone
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $DestinationZone;
    /**
     * The BookingCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_BookingCode
     */
    public $BookingCode;
    /**
     * The PackageRequiredFields
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_PackageRequiredFields
     */
    public $PackageRequiredFields;
    /**
     * The CancellationPolicy
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_CancellationPolicyRules
     */
    public $CancellationPolicy;
    /**
     * The CancellationPolicyCost
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_CancellationPolicyRules
     */
    public $CancellationPolicyCost;
    /**
     * The PriceInformation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_PriceInformationPackage
     */
    public $PriceInformation;
    /**
     * The OriginZone
     * @var int
     */
    public $OriginZone;
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * Constructor method for JP_PackageBookingRules
     * @uses JP_PackageBookingRules::setStatus()
     * @uses JP_PackageBookingRules::setStart()
     * @uses JP_PackageBookingRules::setEnd()
     * @uses JP_PackageBookingRules::setDestinationZone()
     * @uses JP_PackageBookingRules::setBookingCode()
     * @uses JP_PackageBookingRules::setPackageRequiredFields()
     * @uses JP_PackageBookingRules::setCancellationPolicy()
     * @uses JP_PackageBookingRules::setCancellationPolicyCost()
     * @uses JP_PackageBookingRules::setPriceInformation()
     * @uses JP_PackageBookingRules::setOriginZone()
     * @uses JP_PackageBookingRules::setCode()
     * @param string $status
     * @param string $start
     * @param string $end
     * @param int $destinationZone
     * @param \StructType\JP_BookingCode $bookingCode
     * @param \StructType\JP_PackageRequiredFields $packageRequiredFields
     * @param \StructType\JP_CancellationPolicyRules $cancellationPolicy
     * @param \StructType\JP_CancellationPolicyRules $cancellationPolicyCost
     * @param \StructType\JP_PriceInformationPackage $priceInformation
     * @param int $originZone
     * @param string $code
     */
    public function __construct($status = null, $start = null, $end = null, $destinationZone = null, \StructType\JP_BookingCode $bookingCode = null, \StructType\JP_PackageRequiredFields $packageRequiredFields = null, \StructType\JP_CancellationPolicyRules $cancellationPolicy = null, \StructType\JP_CancellationPolicyRules $cancellationPolicyCost = null, \StructType\JP_PriceInformationPackage $priceInformation = null, $originZone = null, $code = null)
    {
        $this
            ->setStatus($status)
            ->setStart($start)
            ->setEnd($end)
            ->setDestinationZone($destinationZone)
            ->setBookingCode($bookingCode)
            ->setPackageRequiredFields($packageRequiredFields)
            ->setCancellationPolicy($cancellationPolicy)
            ->setCancellationPolicyCost($cancellationPolicyCost)
            ->setPriceInformation($priceInformation)
            ->setOriginZone($originZone)
            ->setCode($code);
    }
    /**
     * Get Status value
     * @return string
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \EnumType\JP_AvailStatus::valueIsValid()
     * @uses \EnumType\JP_AvailStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\JP_PackageBookingRules
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JP_AvailStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JP_AvailStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \EnumType\JP_AvailStatus::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get Start value
     * @return string
     */
    public function getStart()
    {
        return $this->Start;
    }
    /**
     * Set Start value
     * @param string $start
     * @return \StructType\JP_PackageBookingRules
     */
    public function setStart($start = null)
    {
        // validation for constraint: string
        if (!is_null($start) && !is_string($start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($start, true), gettype($start)), __LINE__);
        }
        $this->Start = $start;
        return $this;
    }
    /**
     * Get End value
     * @return string
     */
    public function getEnd()
    {
        return $this->End;
    }
    /**
     * Set End value
     * @param string $end
     * @return \StructType\JP_PackageBookingRules
     */
    public function setEnd($end = null)
    {
        // validation for constraint: string
        if (!is_null($end) && !is_string($end)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($end, true), gettype($end)), __LINE__);
        }
        $this->End = $end;
        return $this;
    }
    /**
     * Get DestinationZone value
     * @return int
     */
    public function getDestinationZone()
    {
        return $this->DestinationZone;
    }
    /**
     * Set DestinationZone value
     * @param int $destinationZone
     * @return \StructType\JP_PackageBookingRules
     */
    public function setDestinationZone($destinationZone = null)
    {
        // validation for constraint: int
        if (!is_null($destinationZone) && !(is_int($destinationZone) || ctype_digit($destinationZone))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($destinationZone, true), gettype($destinationZone)), __LINE__);
        }
        $this->DestinationZone = $destinationZone;
        return $this;
    }
    /**
     * Get BookingCode value
     * @return \StructType\JP_BookingCode|null
     */
    public function getBookingCode()
    {
        return $this->BookingCode;
    }
    /**
     * Set BookingCode value
     * @param \StructType\JP_BookingCode $bookingCode
     * @return \StructType\JP_PackageBookingRules
     */
    public function setBookingCode(\StructType\JP_BookingCode $bookingCode = null)
    {
        $this->BookingCode = $bookingCode;
        return $this;
    }
    /**
     * Get PackageRequiredFields value
     * @return \StructType\JP_PackageRequiredFields|null
     */
    public function getPackageRequiredFields()
    {
        return $this->PackageRequiredFields;
    }
    /**
     * Set PackageRequiredFields value
     * @param \StructType\JP_PackageRequiredFields $packageRequiredFields
     * @return \StructType\JP_PackageBookingRules
     */
    public function setPackageRequiredFields(\StructType\JP_PackageRequiredFields $packageRequiredFields = null)
    {
        $this->PackageRequiredFields = $packageRequiredFields;
        return $this;
    }
    /**
     * Get CancellationPolicy value
     * @return \StructType\JP_CancellationPolicyRules|null
     */
    public function getCancellationPolicy()
    {
        return $this->CancellationPolicy;
    }
    /**
     * Set CancellationPolicy value
     * @param \StructType\JP_CancellationPolicyRules $cancellationPolicy
     * @return \StructType\JP_PackageBookingRules
     */
    public function setCancellationPolicy(\StructType\JP_CancellationPolicyRules $cancellationPolicy = null)
    {
        $this->CancellationPolicy = $cancellationPolicy;
        return $this;
    }
    /**
     * Get CancellationPolicyCost value
     * @return \StructType\JP_CancellationPolicyRules|null
     */
    public function getCancellationPolicyCost()
    {
        return $this->CancellationPolicyCost;
    }
    /**
     * Set CancellationPolicyCost value
     * @param \StructType\JP_CancellationPolicyRules $cancellationPolicyCost
     * @return \StructType\JP_PackageBookingRules
     */
    public function setCancellationPolicyCost(\StructType\JP_CancellationPolicyRules $cancellationPolicyCost = null)
    {
        $this->CancellationPolicyCost = $cancellationPolicyCost;
        return $this;
    }
    /**
     * Get PriceInformation value
     * @return \StructType\JP_PriceInformationPackage|null
     */
    public function getPriceInformation()
    {
        return $this->PriceInformation;
    }
    /**
     * Set PriceInformation value
     * @param \StructType\JP_PriceInformationPackage $priceInformation
     * @return \StructType\JP_PackageBookingRules
     */
    public function setPriceInformation(\StructType\JP_PriceInformationPackage $priceInformation = null)
    {
        $this->PriceInformation = $priceInformation;
        return $this;
    }
    /**
     * Get OriginZone value
     * @return int|null
     */
    public function getOriginZone()
    {
        return $this->OriginZone;
    }
    /**
     * Set OriginZone value
     * @param int $originZone
     * @return \StructType\JP_PackageBookingRules
     */
    public function setOriginZone($originZone = null)
    {
        // validation for constraint: int
        if (!is_null($originZone) && !(is_int($originZone) || ctype_digit($originZone))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($originZone, true), gettype($originZone)), __LINE__);
        }
        $this->OriginZone = $originZone;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\JP_PackageBookingRules
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_PackageBookingRules
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
