<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_CruiseItinerary StructType
 * @subpackage Structs
 */
class JP_CruiseItinerary extends AbstractStructBase
{
    /**
     * The Sea
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Sea;
    /**
     * The StarDays
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_CruiseStarDay
     */
    public $StarDays;
    /**
     * The Images
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString1
     */
    public $Images;
    /**
     * The Ship
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_Ship
     */
    public $Ship;
    /**
     * The Route
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_Day
     */
    public $Route;
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * The CruiseCode
     * @var string
     */
    public $CruiseCode;
    /**
     * Constructor method for JP_CruiseItinerary
     * @uses JP_CruiseItinerary::setSea()
     * @uses JP_CruiseItinerary::setStarDays()
     * @uses JP_CruiseItinerary::setImages()
     * @uses JP_CruiseItinerary::setShip()
     * @uses JP_CruiseItinerary::setRoute()
     * @uses JP_CruiseItinerary::setCode()
     * @uses JP_CruiseItinerary::setCruiseCode()
     * @param string $sea
     * @param \ArrayType\ArrayOfJP_CruiseStarDay $starDays
     * @param \ArrayType\ArrayOfString1 $images
     * @param \StructType\JP_Ship $ship
     * @param \ArrayType\ArrayOfJP_Day $route
     * @param string $code
     * @param string $cruiseCode
     */
    public function __construct($sea = null, \ArrayType\ArrayOfJP_CruiseStarDay $starDays = null, \ArrayType\ArrayOfString1 $images = null, \StructType\JP_Ship $ship = null, \ArrayType\ArrayOfJP_Day $route = null, $code = null, $cruiseCode = null)
    {
        $this
            ->setSea($sea)
            ->setStarDays($starDays)
            ->setImages($images)
            ->setShip($ship)
            ->setRoute($route)
            ->setCode($code)
            ->setCruiseCode($cruiseCode);
    }
    /**
     * Get Sea value
     * @return string|null
     */
    public function getSea()
    {
        return $this->Sea;
    }
    /**
     * Set Sea value
     * @param string $sea
     * @return \StructType\JP_CruiseItinerary
     */
    public function setSea($sea = null)
    {
        // validation for constraint: string
        if (!is_null($sea) && !is_string($sea)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sea, true), gettype($sea)), __LINE__);
        }
        $this->Sea = $sea;
        return $this;
    }
    /**
     * Get StarDays value
     * @return \ArrayType\ArrayOfJP_CruiseStarDay|null
     */
    public function getStarDays()
    {
        return $this->StarDays;
    }
    /**
     * Set StarDays value
     * @param \ArrayType\ArrayOfJP_CruiseStarDay $starDays
     * @return \StructType\JP_CruiseItinerary
     */
    public function setStarDays(\ArrayType\ArrayOfJP_CruiseStarDay $starDays = null)
    {
        $this->StarDays = $starDays;
        return $this;
    }
    /**
     * Get Images value
     * @return \ArrayType\ArrayOfString1|null
     */
    public function getImages()
    {
        return $this->Images;
    }
    /**
     * Set Images value
     * @param \ArrayType\ArrayOfString1 $images
     * @return \StructType\JP_CruiseItinerary
     */
    public function setImages(\ArrayType\ArrayOfString1 $images = null)
    {
        $this->Images = $images;
        return $this;
    }
    /**
     * Get Ship value
     * @return \StructType\JP_Ship|null
     */
    public function getShip()
    {
        return $this->Ship;
    }
    /**
     * Set Ship value
     * @param \StructType\JP_Ship $ship
     * @return \StructType\JP_CruiseItinerary
     */
    public function setShip(\StructType\JP_Ship $ship = null)
    {
        $this->Ship = $ship;
        return $this;
    }
    /**
     * Get Route value
     * @return \ArrayType\ArrayOfJP_Day|null
     */
    public function getRoute()
    {
        return $this->Route;
    }
    /**
     * Set Route value
     * @param \ArrayType\ArrayOfJP_Day $route
     * @return \StructType\JP_CruiseItinerary
     */
    public function setRoute(\ArrayType\ArrayOfJP_Day $route = null)
    {
        $this->Route = $route;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\JP_CruiseItinerary
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get CruiseCode value
     * @return string|null
     */
    public function getCruiseCode()
    {
        return $this->CruiseCode;
    }
    /**
     * Set CruiseCode value
     * @param string $cruiseCode
     * @return \StructType\JP_CruiseItinerary
     */
    public function setCruiseCode($cruiseCode = null)
    {
        // validation for constraint: string
        if (!is_null($cruiseCode) && !is_string($cruiseCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cruiseCode, true), gettype($cruiseCode)), __LINE__);
        }
        $this->CruiseCode = $cruiseCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_CruiseItinerary
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
