<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_CityComplex StructType
 * @subpackage Structs
 */
class JP_CityComplex extends AbstractStructBase
{
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Country
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_ZoneIdName
     */
    public $Country;
    /**
     * The Region
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_ZoneIdName
     */
    public $Region;
    /**
     * The Id
     * @var string
     */
    public $Id;
    /**
     * The JPDCode
     * @var string
     */
    public $JPDCode;
    /**
     * Constructor method for JP_CityComplex
     * @uses JP_CityComplex::setName()
     * @uses JP_CityComplex::setCountry()
     * @uses JP_CityComplex::setRegion()
     * @uses JP_CityComplex::setId()
     * @uses JP_CityComplex::setJPDCode()
     * @param string $name
     * @param \StructType\JP_ZoneIdName $country
     * @param \StructType\JP_ZoneIdName $region
     * @param string $id
     * @param string $jPDCode
     */
    public function __construct($name = null, \StructType\JP_ZoneIdName $country = null, \StructType\JP_ZoneIdName $region = null, $id = null, $jPDCode = null)
    {
        $this
            ->setName($name)
            ->setCountry($country)
            ->setRegion($region)
            ->setId($id)
            ->setJPDCode($jPDCode);
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\JP_CityComplex
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Country value
     * @return \StructType\JP_ZoneIdName|null
     */
    public function getCountry()
    {
        return $this->Country;
    }
    /**
     * Set Country value
     * @param \StructType\JP_ZoneIdName $country
     * @return \StructType\JP_CityComplex
     */
    public function setCountry(\StructType\JP_ZoneIdName $country = null)
    {
        $this->Country = $country;
        return $this;
    }
    /**
     * Get Region value
     * @return \StructType\JP_ZoneIdName|null
     */
    public function getRegion()
    {
        return $this->Region;
    }
    /**
     * Set Region value
     * @param \StructType\JP_ZoneIdName $region
     * @return \StructType\JP_CityComplex
     */
    public function setRegion(\StructType\JP_ZoneIdName $region = null)
    {
        $this->Region = $region;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\JP_CityComplex
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get JPDCode value
     * @return string|null
     */
    public function getJPDCode()
    {
        return $this->JPDCode;
    }
    /**
     * Set JPDCode value
     * @param string $jPDCode
     * @return \StructType\JP_CityComplex
     */
    public function setJPDCode($jPDCode = null)
    {
        // validation for constraint: string
        if (!is_null($jPDCode) && !is_string($jPDCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($jPDCode, true), gettype($jPDCode)), __LINE__);
        }
        $this->JPDCode = $jPDCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_CityComplex
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
