<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JPSOAP_HotelRatePlanFreeNightsOffer StructType
 * @subpackage Structs
 */
class JPSOAP_HotelRatePlanFreeNightsOffer extends AbstractStructBase
{
    /**
     * The Nights
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $Nights;
    /**
     * The Free
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $Free;
    /**
     * The Quote
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Quote;
    /**
     * The ApplyOnce
     * Meta informations extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $ApplyOnce;
    /**
     * Constructor method for JPSOAP_HotelRatePlanFreeNightsOffer
     * @uses JPSOAP_HotelRatePlanFreeNightsOffer::setNights()
     * @uses JPSOAP_HotelRatePlanFreeNightsOffer::setFree()
     * @uses JPSOAP_HotelRatePlanFreeNightsOffer::setQuote()
     * @uses JPSOAP_HotelRatePlanFreeNightsOffer::setApplyOnce()
     * @param int $nights
     * @param int $free
     * @param string $quote
     * @param bool $applyOnce
     */
    public function __construct($nights = null, $free = null, $quote = null, $applyOnce = null)
    {
        $this
            ->setNights($nights)
            ->setFree($free)
            ->setQuote($quote)
            ->setApplyOnce($applyOnce);
    }
    /**
     * Get Nights value
     * @return int
     */
    public function getNights()
    {
        return $this->Nights;
    }
    /**
     * Set Nights value
     * @param int $nights
     * @return \StructType\JPSOAP_HotelRatePlanFreeNightsOffer
     */
    public function setNights($nights = null)
    {
        // validation for constraint: int
        if (!is_null($nights) && !(is_int($nights) || ctype_digit($nights))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nights, true), gettype($nights)), __LINE__);
        }
        $this->Nights = $nights;
        return $this;
    }
    /**
     * Get Free value
     * @return int
     */
    public function getFree()
    {
        return $this->Free;
    }
    /**
     * Set Free value
     * @param int $free
     * @return \StructType\JPSOAP_HotelRatePlanFreeNightsOffer
     */
    public function setFree($free = null)
    {
        // validation for constraint: int
        if (!is_null($free) && !(is_int($free) || ctype_digit($free))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($free, true), gettype($free)), __LINE__);
        }
        $this->Free = $free;
        return $this;
    }
    /**
     * Get Quote value
     * @return string
     */
    public function getQuote()
    {
        return $this->Quote;
    }
    /**
     * Set Quote value
     * @uses \EnumType\JPSOAP_FreeNightsOfferQuotation::valueIsValid()
     * @uses \EnumType\JPSOAP_FreeNightsOfferQuotation::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $quote
     * @return \StructType\JPSOAP_HotelRatePlanFreeNightsOffer
     */
    public function setQuote($quote = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JPSOAP_FreeNightsOfferQuotation::valueIsValid($quote)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JPSOAP_FreeNightsOfferQuotation', is_array($quote) ? implode(', ', $quote) : var_export($quote, true), implode(', ', \EnumType\JPSOAP_FreeNightsOfferQuotation::getValidValues())), __LINE__);
        }
        $this->Quote = $quote;
        return $this;
    }
    /**
     * Get ApplyOnce value
     * @return bool
     */
    public function getApplyOnce()
    {
        return $this->ApplyOnce;
    }
    /**
     * Set ApplyOnce value
     * @param bool $applyOnce
     * @return \StructType\JPSOAP_HotelRatePlanFreeNightsOffer
     */
    public function setApplyOnce($applyOnce = null)
    {
        // validation for constraint: boolean
        if (!is_null($applyOnce) && !is_bool($applyOnce)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($applyOnce, true), gettype($applyOnce)), __LINE__);
        }
        $this->ApplyOnce = $applyOnce;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JPSOAP_HotelRatePlanFreeNightsOffer
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
