<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfString4 ArrayType
 * @subpackage Arrays
 */
class ArrayOfString4 extends AbstractStructArrayBase
{
    /**
     * The Situation
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $Situation;
    /**
     * Constructor method for ArrayOfString4
     * @uses ArrayOfString4::setSituation()
     * @param string[] $situation
     */
    public function __construct(array $situation = array())
    {
        $this
            ->setSituation($situation);
    }
    /**
     * Get Situation value
     * @return string[]|null
     */
    public function getSituation()
    {
        return $this->Situation;
    }
    /**
     * This method is responsible for validating the values passed to the setSituation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSituation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSituationForArrayConstraintsFromSetSituation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfString4SituationItem) {
            // validation for constraint: itemType
            if (!is_string($arrayOfString4SituationItem)) {
                $invalidValues[] = is_object($arrayOfString4SituationItem) ? get_class($arrayOfString4SituationItem) : sprintf('%s(%s)', gettype($arrayOfString4SituationItem), var_export($arrayOfString4SituationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Situation property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Situation value
     * @throws \InvalidArgumentException
     * @param string[] $situation
     * @return \ArrayType\ArrayOfString4
     */
    public function setSituation(array $situation = array())
    {
        // validation for constraint: array
        if ('' !== ($situationArrayErrorMessage = self::validateSituationForArrayConstraintsFromSetSituation($situation))) {
            throw new \InvalidArgumentException($situationArrayErrorMessage, __LINE__);
        }
        $this->Situation = $situation;
        return $this;
    }
    /**
     * Add item to Situation value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \ArrayType\ArrayOfString4
     */
    public function addToSituation($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The Situation property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Situation[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return string|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return string|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return string|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return string|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return string|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Situation
     */
    public function getAttributeName()
    {
        return 'Situation';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfString4
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
