<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfJP_CustomerStaticData ArrayType
 * @subpackage Arrays
 */
class ArrayOfJP_CustomerStaticData extends AbstractStructArrayBase
{
    /**
     * The Customer
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_CustomerStaticData[]
     */
    public $Customer;
    /**
     * Constructor method for ArrayOfJP_CustomerStaticData
     * @uses ArrayOfJP_CustomerStaticData::setCustomer()
     * @param \StructType\JP_CustomerStaticData[] $customer
     */
    public function __construct(array $customer = array())
    {
        $this
            ->setCustomer($customer);
    }
    /**
     * Get Customer value
     * @return \StructType\JP_CustomerStaticData[]|null
     */
    public function getCustomer()
    {
        return $this->Customer;
    }
    /**
     * This method is responsible for validating the values passed to the setCustomer method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustomer method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustomerForArrayConstraintsFromSetCustomer(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfJP_CustomerStaticDataCustomerItem) {
            // validation for constraint: itemType
            if (!$arrayOfJP_CustomerStaticDataCustomerItem instanceof \StructType\JP_CustomerStaticData) {
                $invalidValues[] = is_object($arrayOfJP_CustomerStaticDataCustomerItem) ? get_class($arrayOfJP_CustomerStaticDataCustomerItem) : sprintf('%s(%s)', gettype($arrayOfJP_CustomerStaticDataCustomerItem), var_export($arrayOfJP_CustomerStaticDataCustomerItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Customer property can only contain items of type \StructType\JP_CustomerStaticData, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Customer value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_CustomerStaticData[] $customer
     * @return \ArrayType\ArrayOfJP_CustomerStaticData
     */
    public function setCustomer(array $customer = array())
    {
        // validation for constraint: array
        if ('' !== ($customerArrayErrorMessage = self::validateCustomerForArrayConstraintsFromSetCustomer($customer))) {
            throw new \InvalidArgumentException($customerArrayErrorMessage, __LINE__);
        }
        $this->Customer = $customer;
        return $this;
    }
    /**
     * Add item to Customer value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_CustomerStaticData $item
     * @return \ArrayType\ArrayOfJP_CustomerStaticData
     */
    public function addToCustomer(\StructType\JP_CustomerStaticData $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_CustomerStaticData) {
            throw new \InvalidArgumentException(sprintf('The Customer property can only contain items of type \StructType\JP_CustomerStaticData, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Customer[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\JP_CustomerStaticData|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\JP_CustomerStaticData|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\JP_CustomerStaticData|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\JP_CustomerStaticData|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\JP_CustomerStaticData|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Customer
     */
    public function getAttributeName()
    {
        return 'Customer';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfJP_CustomerStaticData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
