<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfJP_Coverage ArrayType
 * @subpackage Arrays
 */
class ArrayOfJP_Coverage extends AbstractStructArrayBase
{
    /**
     * The Coverage
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_Coverage[]
     */
    public $Coverage;
    /**
     * Constructor method for ArrayOfJP_Coverage
     * @uses ArrayOfJP_Coverage::setCoverage()
     * @param \StructType\JP_Coverage[] $coverage
     */
    public function __construct(array $coverage = array())
    {
        $this
            ->setCoverage($coverage);
    }
    /**
     * Get Coverage value
     * @return \StructType\JP_Coverage[]|null
     */
    public function getCoverage()
    {
        return $this->Coverage;
    }
    /**
     * This method is responsible for validating the values passed to the setCoverage method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCoverage method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCoverageForArrayConstraintsFromSetCoverage(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfJP_CoverageCoverageItem) {
            // validation for constraint: itemType
            if (!$arrayOfJP_CoverageCoverageItem instanceof \StructType\JP_Coverage) {
                $invalidValues[] = is_object($arrayOfJP_CoverageCoverageItem) ? get_class($arrayOfJP_CoverageCoverageItem) : sprintf('%s(%s)', gettype($arrayOfJP_CoverageCoverageItem), var_export($arrayOfJP_CoverageCoverageItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Coverage property can only contain items of type \StructType\JP_Coverage, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Coverage value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_Coverage[] $coverage
     * @return \ArrayType\ArrayOfJP_Coverage
     */
    public function setCoverage(array $coverage = array())
    {
        // validation for constraint: array
        if ('' !== ($coverageArrayErrorMessage = self::validateCoverageForArrayConstraintsFromSetCoverage($coverage))) {
            throw new \InvalidArgumentException($coverageArrayErrorMessage, __LINE__);
        }
        $this->Coverage = $coverage;
        return $this;
    }
    /**
     * Add item to Coverage value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_Coverage $item
     * @return \ArrayType\ArrayOfJP_Coverage
     */
    public function addToCoverage(\StructType\JP_Coverage $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_Coverage) {
            throw new \InvalidArgumentException(sprintf('The Coverage property can only contain items of type \StructType\JP_Coverage, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Coverage[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\JP_Coverage|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\JP_Coverage|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\JP_Coverage|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\JP_Coverage|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\JP_Coverage|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Coverage
     */
    public function getAttributeName()
    {
        return 'Coverage';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfJP_Coverage
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
