<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_VisaOption StructType
 * @subpackage Structs
 */
class JP_VisaOption extends AbstractStructBase
{
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The OccupancyAllowed
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_Ocuppancy
     */
    public $OccupancyAllowed;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The Images
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString1
     */
    public $Images;
    /**
     * The DestinationName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DestinationName;
    /**
     * The Dates
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_ServiceDate
     */
    public $Dates;
    /**
     * The Languages
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_Language
     */
    public $Languages;
    /**
     * The Start
     * @var string
     */
    public $Start;
    /**
     * The End
     * @var string
     */
    public $End;
    /**
     * The Destination
     * @var int
     */
    public $Destination;
    /**
     * The Duration
     * @var string
     */
    public $Duration;
    /**
     * Constructor method for JP_VisaOption
     * @uses JP_VisaOption::setName()
     * @uses JP_VisaOption::setOccupancyAllowed()
     * @uses JP_VisaOption::setDescription()
     * @uses JP_VisaOption::setImages()
     * @uses JP_VisaOption::setDestinationName()
     * @uses JP_VisaOption::setDates()
     * @uses JP_VisaOption::setLanguages()
     * @uses JP_VisaOption::setStart()
     * @uses JP_VisaOption::setEnd()
     * @uses JP_VisaOption::setDestination()
     * @uses JP_VisaOption::setDuration()
     * @param string $name
     * @param \StructType\JP_Ocuppancy $occupancyAllowed
     * @param string $description
     * @param \ArrayType\ArrayOfString1 $images
     * @param string $destinationName
     * @param \ArrayType\ArrayOfJP_ServiceDate $dates
     * @param \ArrayType\ArrayOfJP_Language $languages
     * @param string $start
     * @param string $end
     * @param int $destination
     * @param string $duration
     */
    public function __construct($name = null, \StructType\JP_Ocuppancy $occupancyAllowed = null, $description = null, \ArrayType\ArrayOfString1 $images = null, $destinationName = null, \ArrayType\ArrayOfJP_ServiceDate $dates = null, \ArrayType\ArrayOfJP_Language $languages = null, $start = null, $end = null, $destination = null, $duration = null)
    {
        $this
            ->setName($name)
            ->setOccupancyAllowed($occupancyAllowed)
            ->setDescription($description)
            ->setImages($images)
            ->setDestinationName($destinationName)
            ->setDates($dates)
            ->setLanguages($languages)
            ->setStart($start)
            ->setEnd($end)
            ->setDestination($destination)
            ->setDuration($duration);
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\JP_VisaOption
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get OccupancyAllowed value
     * @return \StructType\JP_Ocuppancy|null
     */
    public function getOccupancyAllowed()
    {
        return $this->OccupancyAllowed;
    }
    /**
     * Set OccupancyAllowed value
     * @param \StructType\JP_Ocuppancy $occupancyAllowed
     * @return \StructType\JP_VisaOption
     */
    public function setOccupancyAllowed(\StructType\JP_Ocuppancy $occupancyAllowed = null)
    {
        $this->OccupancyAllowed = $occupancyAllowed;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\JP_VisaOption
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Images value
     * @return \ArrayType\ArrayOfString1|null
     */
    public function getImages()
    {
        return $this->Images;
    }
    /**
     * Set Images value
     * @param \ArrayType\ArrayOfString1 $images
     * @return \StructType\JP_VisaOption
     */
    public function setImages(\ArrayType\ArrayOfString1 $images = null)
    {
        $this->Images = $images;
        return $this;
    }
    /**
     * Get DestinationName value
     * @return string|null
     */
    public function getDestinationName()
    {
        return $this->DestinationName;
    }
    /**
     * Set DestinationName value
     * @param string $destinationName
     * @return \StructType\JP_VisaOption
     */
    public function setDestinationName($destinationName = null)
    {
        // validation for constraint: string
        if (!is_null($destinationName) && !is_string($destinationName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destinationName, true), gettype($destinationName)), __LINE__);
        }
        $this->DestinationName = $destinationName;
        return $this;
    }
    /**
     * Get Dates value
     * @return \ArrayType\ArrayOfJP_ServiceDate|null
     */
    public function getDates()
    {
        return $this->Dates;
    }
    /**
     * Set Dates value
     * @param \ArrayType\ArrayOfJP_ServiceDate $dates
     * @return \StructType\JP_VisaOption
     */
    public function setDates(\ArrayType\ArrayOfJP_ServiceDate $dates = null)
    {
        $this->Dates = $dates;
        return $this;
    }
    /**
     * Get Languages value
     * @return \ArrayType\ArrayOfJP_Language|null
     */
    public function getLanguages()
    {
        return $this->Languages;
    }
    /**
     * Set Languages value
     * @param \ArrayType\ArrayOfJP_Language $languages
     * @return \StructType\JP_VisaOption
     */
    public function setLanguages(\ArrayType\ArrayOfJP_Language $languages = null)
    {
        $this->Languages = $languages;
        return $this;
    }
    /**
     * Get Start value
     * @return string|null
     */
    public function getStart()
    {
        return $this->Start;
    }
    /**
     * Set Start value
     * @param string $start
     * @return \StructType\JP_VisaOption
     */
    public function setStart($start = null)
    {
        // validation for constraint: string
        if (!is_null($start) && !is_string($start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($start, true), gettype($start)), __LINE__);
        }
        $this->Start = $start;
        return $this;
    }
    /**
     * Get End value
     * @return string|null
     */
    public function getEnd()
    {
        return $this->End;
    }
    /**
     * Set End value
     * @param string $end
     * @return \StructType\JP_VisaOption
     */
    public function setEnd($end = null)
    {
        // validation for constraint: string
        if (!is_null($end) && !is_string($end)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($end, true), gettype($end)), __LINE__);
        }
        $this->End = $end;
        return $this;
    }
    /**
     * Get Destination value
     * @return int|null
     */
    public function getDestination()
    {
        return $this->Destination;
    }
    /**
     * Set Destination value
     * @param int $destination
     * @return \StructType\JP_VisaOption
     */
    public function setDestination($destination = null)
    {
        // validation for constraint: int
        if (!is_null($destination) && !(is_int($destination) || ctype_digit($destination))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($destination, true), gettype($destination)), __LINE__);
        }
        $this->Destination = $destination;
        return $this;
    }
    /**
     * Get Duration value
     * @return string|null
     */
    public function getDuration()
    {
        return $this->Duration;
    }
    /**
     * Set Duration value
     * @param string $duration
     * @return \StructType\JP_VisaOption
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: string
        if (!is_null($duration) && !is_string($duration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($duration, true), gettype($duration)), __LINE__);
        }
        $this->Duration = $duration;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_VisaOption
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
