<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_TransferItem StructType
 * @subpackage Structs
 */
class JP_TransferItem extends JP_BaseItem
{
    /**
     * The Start
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Start;
    /**
     * The End
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $End;
    /**
     * The TransferInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_TransferInfo
     */
    public $TransferInfo;
    /**
     * The AdditionalElements
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_PackageAdditionalElements
     */
    public $AdditionalElements;
    /**
     * The CancellationPolicy
     * Meta informations extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_CancellationPolicyRules
     */
    public $CancellationPolicy;
    /**
     * The TransferOptions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_TransferOption
     */
    public $TransferOptions;
    /**
     * The RelPaxes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_RelPax
     */
    public $RelPaxes;
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * Constructor method for JP_TransferItem
     * @uses JP_TransferItem::setStart()
     * @uses JP_TransferItem::setEnd()
     * @uses JP_TransferItem::setTransferInfo()
     * @uses JP_TransferItem::setAdditionalElements()
     * @uses JP_TransferItem::setCancellationPolicy()
     * @uses JP_TransferItem::setTransferOptions()
     * @uses JP_TransferItem::setRelPaxes()
     * @uses JP_TransferItem::setCode()
     * @param string $start
     * @param string $end
     * @param \StructType\JP_TransferInfo $transferInfo
     * @param \StructType\JP_PackageAdditionalElements $additionalElements
     * @param \StructType\JP_CancellationPolicyRules $cancellationPolicy
     * @param \ArrayType\ArrayOfJP_TransferOption $transferOptions
     * @param \ArrayType\ArrayOfJP_RelPax $relPaxes
     * @param string $code
     */
    public function __construct($start = null, $end = null, \StructType\JP_TransferInfo $transferInfo = null, \StructType\JP_PackageAdditionalElements $additionalElements = null, \StructType\JP_CancellationPolicyRules $cancellationPolicy = null, \ArrayType\ArrayOfJP_TransferOption $transferOptions = null, \ArrayType\ArrayOfJP_RelPax $relPaxes = null, $code = null)
    {
        $this
            ->setStart($start)
            ->setEnd($end)
            ->setTransferInfo($transferInfo)
            ->setAdditionalElements($additionalElements)
            ->setCancellationPolicy($cancellationPolicy)
            ->setTransferOptions($transferOptions)
            ->setRelPaxes($relPaxes)
            ->setCode($code);
    }
    /**
     * Get Start value
     * @return string
     */
    public function getStart()
    {
        return $this->Start;
    }
    /**
     * Set Start value
     * @param string $start
     * @return \StructType\JP_TransferItem
     */
    public function setStart($start = null)
    {
        // validation for constraint: string
        if (!is_null($start) && !is_string($start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($start, true), gettype($start)), __LINE__);
        }
        $this->Start = $start;
        return $this;
    }
    /**
     * Get End value
     * @return string
     */
    public function getEnd()
    {
        return $this->End;
    }
    /**
     * Set End value
     * @param string $end
     * @return \StructType\JP_TransferItem
     */
    public function setEnd($end = null)
    {
        // validation for constraint: string
        if (!is_null($end) && !is_string($end)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($end, true), gettype($end)), __LINE__);
        }
        $this->End = $end;
        return $this;
    }
    /**
     * Get TransferInfo value
     * @return \StructType\JP_TransferInfo|null
     */
    public function getTransferInfo()
    {
        return $this->TransferInfo;
    }
    /**
     * Set TransferInfo value
     * @param \StructType\JP_TransferInfo $transferInfo
     * @return \StructType\JP_TransferItem
     */
    public function setTransferInfo(\StructType\JP_TransferInfo $transferInfo = null)
    {
        $this->TransferInfo = $transferInfo;
        return $this;
    }
    /**
     * Get AdditionalElements value
     * @return \StructType\JP_PackageAdditionalElements|null
     */
    public function getAdditionalElements()
    {
        return $this->AdditionalElements;
    }
    /**
     * Set AdditionalElements value
     * @param \StructType\JP_PackageAdditionalElements $additionalElements
     * @return \StructType\JP_TransferItem
     */
    public function setAdditionalElements(\StructType\JP_PackageAdditionalElements $additionalElements = null)
    {
        $this->AdditionalElements = $additionalElements;
        return $this;
    }
    /**
     * Get CancellationPolicy value
     * @return \StructType\JP_CancellationPolicyRules|null
     */
    public function getCancellationPolicy()
    {
        return $this->CancellationPolicy;
    }
    /**
     * Set CancellationPolicy value
     * @param \StructType\JP_CancellationPolicyRules $cancellationPolicy
     * @return \StructType\JP_TransferItem
     */
    public function setCancellationPolicy(\StructType\JP_CancellationPolicyRules $cancellationPolicy = null)
    {
        $this->CancellationPolicy = $cancellationPolicy;
        return $this;
    }
    /**
     * Get TransferOptions value
     * @return \ArrayType\ArrayOfJP_TransferOption|null
     */
    public function getTransferOptions()
    {
        return $this->TransferOptions;
    }
    /**
     * Set TransferOptions value
     * @param \ArrayType\ArrayOfJP_TransferOption $transferOptions
     * @return \StructType\JP_TransferItem
     */
    public function setTransferOptions(\ArrayType\ArrayOfJP_TransferOption $transferOptions = null)
    {
        $this->TransferOptions = $transferOptions;
        return $this;
    }
    /**
     * Get RelPaxes value
     * @return \ArrayType\ArrayOfJP_RelPax|null
     */
    public function getRelPaxes()
    {
        return $this->RelPaxes;
    }
    /**
     * Set RelPaxes value
     * @param \ArrayType\ArrayOfJP_RelPax $relPaxes
     * @return \StructType\JP_TransferItem
     */
    public function setRelPaxes(\ArrayType\ArrayOfJP_RelPax $relPaxes = null)
    {
        $this->RelPaxes = $relPaxes;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\JP_TransferItem
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_TransferItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
