<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_ServiceType StructType
 * @subpackage Structs
 */
class JP_ServiceType extends AbstractStructBase
{
    /**
     * The Code
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $Code;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The ParentCode
     * @var int
     */
    public $ParentCode;
    /**
     * Constructor method for JP_ServiceType
     * @uses JP_ServiceType::setCode()
     * @uses JP_ServiceType::setName()
     * @uses JP_ServiceType::setParentCode()
     * @param int $code
     * @param string $name
     * @param int $parentCode
     */
    public function __construct($code = null, $name = null, $parentCode = null)
    {
        $this
            ->setCode($code)
            ->setName($name)
            ->setParentCode($parentCode);
    }
    /**
     * Get Code value
     * @return int
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param int $code
     * @return \StructType\JP_ServiceType
     */
    public function setCode($code = null)
    {
        // validation for constraint: int
        if (!is_null($code) && !(is_int($code) || ctype_digit($code))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\JP_ServiceType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get ParentCode value
     * @return int|null
     */
    public function getParentCode()
    {
        return $this->ParentCode;
    }
    /**
     * Set ParentCode value
     * @param int $parentCode
     * @return \StructType\JP_ServiceType
     */
    public function setParentCode($parentCode = null)
    {
        // validation for constraint: int
        if (!is_null($parentCode) && !(is_int($parentCode) || ctype_digit($parentCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($parentCode, true), gettype($parentCode)), __LINE__);
        }
        $this->ParentCode = $parentCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_ServiceType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
