<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_PaymentInfo StructType
 * @subpackage Structs
 */
class JP_PaymentInfo extends AbstractStructBase
{
    /**
     * The Price
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_PaymentPrice
     */
    public $Price;
    /**
     * The OrderCode
     * @var string
     */
    public $OrderCode;
    /**
     * The PaymentCode
     * @var string
     */
    public $PaymentCode;
    /**
     * The AcceptanceCode
     * @var string
     */
    public $AcceptanceCode;
    /**
     * The ECI
     * @var int
     */
    public $ECI;
    /**
     * The PaymentMethod
     * @var string
     */
    public $PaymentMethod;
    /**
     * The BrandCard
     * @var string
     */
    public $BrandCard;
    /**
     * Constructor method for JP_PaymentInfo
     * @uses JP_PaymentInfo::setPrice()
     * @uses JP_PaymentInfo::setOrderCode()
     * @uses JP_PaymentInfo::setPaymentCode()
     * @uses JP_PaymentInfo::setAcceptanceCode()
     * @uses JP_PaymentInfo::setECI()
     * @uses JP_PaymentInfo::setPaymentMethod()
     * @uses JP_PaymentInfo::setBrandCard()
     * @param \StructType\JP_PaymentPrice $price
     * @param string $orderCode
     * @param string $paymentCode
     * @param string $acceptanceCode
     * @param int $eCI
     * @param string $paymentMethod
     * @param string $brandCard
     */
    public function __construct(\StructType\JP_PaymentPrice $price = null, $orderCode = null, $paymentCode = null, $acceptanceCode = null, $eCI = null, $paymentMethod = null, $brandCard = null)
    {
        $this
            ->setPrice($price)
            ->setOrderCode($orderCode)
            ->setPaymentCode($paymentCode)
            ->setAcceptanceCode($acceptanceCode)
            ->setECI($eCI)
            ->setPaymentMethod($paymentMethod)
            ->setBrandCard($brandCard);
    }
    /**
     * Get Price value
     * @return \StructType\JP_PaymentPrice|null
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * Set Price value
     * @param \StructType\JP_PaymentPrice $price
     * @return \StructType\JP_PaymentInfo
     */
    public function setPrice(\StructType\JP_PaymentPrice $price = null)
    {
        $this->Price = $price;
        return $this;
    }
    /**
     * Get OrderCode value
     * @return string|null
     */
    public function getOrderCode()
    {
        return $this->OrderCode;
    }
    /**
     * Set OrderCode value
     * @param string $orderCode
     * @return \StructType\JP_PaymentInfo
     */
    public function setOrderCode($orderCode = null)
    {
        // validation for constraint: string
        if (!is_null($orderCode) && !is_string($orderCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderCode, true), gettype($orderCode)), __LINE__);
        }
        $this->OrderCode = $orderCode;
        return $this;
    }
    /**
     * Get PaymentCode value
     * @return string|null
     */
    public function getPaymentCode()
    {
        return $this->PaymentCode;
    }
    /**
     * Set PaymentCode value
     * @param string $paymentCode
     * @return \StructType\JP_PaymentInfo
     */
    public function setPaymentCode($paymentCode = null)
    {
        // validation for constraint: string
        if (!is_null($paymentCode) && !is_string($paymentCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentCode, true), gettype($paymentCode)), __LINE__);
        }
        $this->PaymentCode = $paymentCode;
        return $this;
    }
    /**
     * Get AcceptanceCode value
     * @return string|null
     */
    public function getAcceptanceCode()
    {
        return $this->AcceptanceCode;
    }
    /**
     * Set AcceptanceCode value
     * @param string $acceptanceCode
     * @return \StructType\JP_PaymentInfo
     */
    public function setAcceptanceCode($acceptanceCode = null)
    {
        // validation for constraint: string
        if (!is_null($acceptanceCode) && !is_string($acceptanceCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($acceptanceCode, true), gettype($acceptanceCode)), __LINE__);
        }
        $this->AcceptanceCode = $acceptanceCode;
        return $this;
    }
    /**
     * Get ECI value
     * @return int|null
     */
    public function getECI()
    {
        return $this->ECI;
    }
    /**
     * Set ECI value
     * @param int $eCI
     * @return \StructType\JP_PaymentInfo
     */
    public function setECI($eCI = null)
    {
        // validation for constraint: int
        if (!is_null($eCI) && !(is_int($eCI) || ctype_digit($eCI))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($eCI, true), gettype($eCI)), __LINE__);
        }
        $this->ECI = $eCI;
        return $this;
    }
    /**
     * Get PaymentMethod value
     * @return string|null
     */
    public function getPaymentMethod()
    {
        return $this->PaymentMethod;
    }
    /**
     * Set PaymentMethod value
     * @param string $paymentMethod
     * @return \StructType\JP_PaymentInfo
     */
    public function setPaymentMethod($paymentMethod = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethod) && !is_string($paymentMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethod, true), gettype($paymentMethod)), __LINE__);
        }
        $this->PaymentMethod = $paymentMethod;
        return $this;
    }
    /**
     * Get BrandCard value
     * @return string|null
     */
    public function getBrandCard()
    {
        return $this->BrandCard;
    }
    /**
     * Set BrandCard value
     * @param string $brandCard
     * @return \StructType\JP_PaymentInfo
     */
    public function setBrandCard($brandCard = null)
    {
        // validation for constraint: string
        if (!is_null($brandCard) && !is_string($brandCard)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($brandCard, true), gettype($brandCard)), __LINE__);
        }
        $this->BrandCard = $brandCard;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_PaymentInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
