<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_PackageHotel StructType
 * @subpackage Structs
 */
class JP_PackageHotel extends AbstractStructBase
{
    /**
     * The Start
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Start;
    /**
     * The End
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $End;
    /**
     * The HotelInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_HotelInfo
     */
    public $HotelInfo;
    /**
     * The HotelOptions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_HotelOption
     */
    public $HotelOptions;
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * The JPCode
     * @var string
     */
    public $JPCode;
    /**
     * The ICode
     * @var string
     */
    public $ICode;
    /**
     * The SearchMore
     * @var bool
     */
    public $SearchMore;
    /**
     * The Order
     * @var int
     */
    public $Order;
    /**
     * The Recommended
     * @var bool
     */
    public $Recommended;
    /**
     * The Priority
     * @var int
     */
    public $Priority;
    /**
     * Constructor method for JP_PackageHotel
     * @uses JP_PackageHotel::setStart()
     * @uses JP_PackageHotel::setEnd()
     * @uses JP_PackageHotel::setHotelInfo()
     * @uses JP_PackageHotel::setHotelOptions()
     * @uses JP_PackageHotel::setCode()
     * @uses JP_PackageHotel::setJPCode()
     * @uses JP_PackageHotel::setICode()
     * @uses JP_PackageHotel::setSearchMore()
     * @uses JP_PackageHotel::setOrder()
     * @uses JP_PackageHotel::setRecommended()
     * @uses JP_PackageHotel::setPriority()
     * @param string $start
     * @param string $end
     * @param \StructType\JP_HotelInfo $hotelInfo
     * @param \ArrayType\ArrayOfJP_HotelOption $hotelOptions
     * @param string $code
     * @param string $jPCode
     * @param string $iCode
     * @param bool $searchMore
     * @param int $order
     * @param bool $recommended
     * @param int $priority
     */
    public function __construct($start = null, $end = null, \StructType\JP_HotelInfo $hotelInfo = null, \ArrayType\ArrayOfJP_HotelOption $hotelOptions = null, $code = null, $jPCode = null, $iCode = null, $searchMore = null, $order = null, $recommended = null, $priority = null)
    {
        $this
            ->setStart($start)
            ->setEnd($end)
            ->setHotelInfo($hotelInfo)
            ->setHotelOptions($hotelOptions)
            ->setCode($code)
            ->setJPCode($jPCode)
            ->setICode($iCode)
            ->setSearchMore($searchMore)
            ->setOrder($order)
            ->setRecommended($recommended)
            ->setPriority($priority);
    }
    /**
     * Get Start value
     * @return string
     */
    public function getStart()
    {
        return $this->Start;
    }
    /**
     * Set Start value
     * @param string $start
     * @return \StructType\JP_PackageHotel
     */
    public function setStart($start = null)
    {
        // validation for constraint: string
        if (!is_null($start) && !is_string($start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($start, true), gettype($start)), __LINE__);
        }
        $this->Start = $start;
        return $this;
    }
    /**
     * Get End value
     * @return string
     */
    public function getEnd()
    {
        return $this->End;
    }
    /**
     * Set End value
     * @param string $end
     * @return \StructType\JP_PackageHotel
     */
    public function setEnd($end = null)
    {
        // validation for constraint: string
        if (!is_null($end) && !is_string($end)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($end, true), gettype($end)), __LINE__);
        }
        $this->End = $end;
        return $this;
    }
    /**
     * Get HotelInfo value
     * @return \StructType\JP_HotelInfo|null
     */
    public function getHotelInfo()
    {
        return $this->HotelInfo;
    }
    /**
     * Set HotelInfo value
     * @param \StructType\JP_HotelInfo $hotelInfo
     * @return \StructType\JP_PackageHotel
     */
    public function setHotelInfo(\StructType\JP_HotelInfo $hotelInfo = null)
    {
        $this->HotelInfo = $hotelInfo;
        return $this;
    }
    /**
     * Get HotelOptions value
     * @return \ArrayType\ArrayOfJP_HotelOption|null
     */
    public function getHotelOptions()
    {
        return $this->HotelOptions;
    }
    /**
     * Set HotelOptions value
     * @param \ArrayType\ArrayOfJP_HotelOption $hotelOptions
     * @return \StructType\JP_PackageHotel
     */
    public function setHotelOptions(\ArrayType\ArrayOfJP_HotelOption $hotelOptions = null)
    {
        $this->HotelOptions = $hotelOptions;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\JP_PackageHotel
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get JPCode value
     * @return string|null
     */
    public function getJPCode()
    {
        return $this->JPCode;
    }
    /**
     * Set JPCode value
     * @param string $jPCode
     * @return \StructType\JP_PackageHotel
     */
    public function setJPCode($jPCode = null)
    {
        // validation for constraint: string
        if (!is_null($jPCode) && !is_string($jPCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($jPCode, true), gettype($jPCode)), __LINE__);
        }
        $this->JPCode = $jPCode;
        return $this;
    }
    /**
     * Get ICode value
     * @return string|null
     */
    public function getICode()
    {
        return $this->ICode;
    }
    /**
     * Set ICode value
     * @param string $iCode
     * @return \StructType\JP_PackageHotel
     */
    public function setICode($iCode = null)
    {
        // validation for constraint: string
        if (!is_null($iCode) && !is_string($iCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iCode, true), gettype($iCode)), __LINE__);
        }
        $this->ICode = $iCode;
        return $this;
    }
    /**
     * Get SearchMore value
     * @return bool|null
     */
    public function getSearchMore()
    {
        return $this->SearchMore;
    }
    /**
     * Set SearchMore value
     * @param bool $searchMore
     * @return \StructType\JP_PackageHotel
     */
    public function setSearchMore($searchMore = null)
    {
        // validation for constraint: boolean
        if (!is_null($searchMore) && !is_bool($searchMore)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($searchMore, true), gettype($searchMore)), __LINE__);
        }
        $this->SearchMore = $searchMore;
        return $this;
    }
    /**
     * Get Order value
     * @return int|null
     */
    public function getOrder()
    {
        return $this->Order;
    }
    /**
     * Set Order value
     * @param int $order
     * @return \StructType\JP_PackageHotel
     */
    public function setOrder($order = null)
    {
        // validation for constraint: int
        if (!is_null($order) && !(is_int($order) || ctype_digit($order))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($order, true), gettype($order)), __LINE__);
        }
        $this->Order = $order;
        return $this;
    }
    /**
     * Get Recommended value
     * @return bool|null
     */
    public function getRecommended()
    {
        return $this->Recommended;
    }
    /**
     * Set Recommended value
     * @param bool $recommended
     * @return \StructType\JP_PackageHotel
     */
    public function setRecommended($recommended = null)
    {
        // validation for constraint: boolean
        if (!is_null($recommended) && !is_bool($recommended)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($recommended, true), gettype($recommended)), __LINE__);
        }
        $this->Recommended = $recommended;
        return $this;
    }
    /**
     * Get Priority value
     * @return int|null
     */
    public function getPriority()
    {
        return $this->Priority;
    }
    /**
     * Set Priority value
     * @param int $priority
     * @return \StructType\JP_PackageHotel
     */
    public function setPriority($priority = null)
    {
        // validation for constraint: int
        if (!is_null($priority) && !(is_int($priority) || ctype_digit($priority))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($priority, true), gettype($priority)), __LINE__);
        }
        $this->Priority = $priority;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_PackageHotel
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
