<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_MeetingPointsZone StructType
 * @subpackage Structs
 */
class JP_MeetingPointsZone extends AbstractStructBase
{
    /**
     * The MeetingPoint
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_MeetingPoint[]
     */
    public $MeetingPoint;
    /**
     * The Name
     * @var string
     */
    public $Name;
    /**
     * Constructor method for JP_MeetingPointsZone
     * @uses JP_MeetingPointsZone::setMeetingPoint()
     * @uses JP_MeetingPointsZone::setName()
     * @param \StructType\JP_MeetingPoint[] $meetingPoint
     * @param string $name
     */
    public function __construct(array $meetingPoint = array(), $name = null)
    {
        $this
            ->setMeetingPoint($meetingPoint)
            ->setName($name);
    }
    /**
     * Get MeetingPoint value
     * @return \StructType\JP_MeetingPoint[]|null
     */
    public function getMeetingPoint()
    {
        return $this->MeetingPoint;
    }
    /**
     * This method is responsible for validating the values passed to the setMeetingPoint method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMeetingPoint method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMeetingPointForArrayConstraintsFromSetMeetingPoint(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $jP_MeetingPointsZoneMeetingPointItem) {
            // validation for constraint: itemType
            if (!$jP_MeetingPointsZoneMeetingPointItem instanceof \StructType\JP_MeetingPoint) {
                $invalidValues[] = is_object($jP_MeetingPointsZoneMeetingPointItem) ? get_class($jP_MeetingPointsZoneMeetingPointItem) : sprintf('%s(%s)', gettype($jP_MeetingPointsZoneMeetingPointItem), var_export($jP_MeetingPointsZoneMeetingPointItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MeetingPoint property can only contain items of type \StructType\JP_MeetingPoint, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MeetingPoint value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_MeetingPoint[] $meetingPoint
     * @return \StructType\JP_MeetingPointsZone
     */
    public function setMeetingPoint(array $meetingPoint = array())
    {
        // validation for constraint: array
        if ('' !== ($meetingPointArrayErrorMessage = self::validateMeetingPointForArrayConstraintsFromSetMeetingPoint($meetingPoint))) {
            throw new \InvalidArgumentException($meetingPointArrayErrorMessage, __LINE__);
        }
        $this->MeetingPoint = $meetingPoint;
        return $this;
    }
    /**
     * Add item to MeetingPoint value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_MeetingPoint $item
     * @return \StructType\JP_MeetingPointsZone
     */
    public function addToMeetingPoint(\StructType\JP_MeetingPoint $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_MeetingPoint) {
            throw new \InvalidArgumentException(sprintf('The MeetingPoint property can only contain items of type \StructType\JP_MeetingPoint, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->MeetingPoint[] = $item;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\JP_MeetingPointsZone
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_MeetingPointsZone
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
