<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_MeetingPointListRequest StructType
 * @subpackage Structs
 */
class JP_MeetingPointListRequest extends AbstractStructBase
{
    /**
     * The ZoneCode
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $ZoneCode;
    /**
     * The ProductType
     * @var string
     */
    public $ProductType;
    /**
     * Constructor method for JP_MeetingPointListRequest
     * @uses JP_MeetingPointListRequest::setZoneCode()
     * @uses JP_MeetingPointListRequest::setProductType()
     * @param int $zoneCode
     * @param string $productType
     */
    public function __construct($zoneCode = null, $productType = null)
    {
        $this
            ->setZoneCode($zoneCode)
            ->setProductType($productType);
    }
    /**
     * Get ZoneCode value
     * @return int
     */
    public function getZoneCode()
    {
        return $this->ZoneCode;
    }
    /**
     * Set ZoneCode value
     * @param int $zoneCode
     * @return \StructType\JP_MeetingPointListRequest
     */
    public function setZoneCode($zoneCode = null)
    {
        // validation for constraint: int
        if (!is_null($zoneCode) && !(is_int($zoneCode) || ctype_digit($zoneCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($zoneCode, true), gettype($zoneCode)), __LINE__);
        }
        $this->ZoneCode = $zoneCode;
        return $this;
    }
    /**
     * Get ProductType value
     * @return string|null
     */
    public function getProductType()
    {
        return $this->ProductType;
    }
    /**
     * Set ProductType value
     * @uses \EnumType\JP_ProductType::valueIsValid()
     * @uses \EnumType\JP_ProductType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $productType
     * @return \StructType\JP_MeetingPointListRequest
     */
    public function setProductType($productType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JP_ProductType::valueIsValid($productType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JP_ProductType', is_array($productType) ? implode(', ', $productType) : var_export($productType, true), implode(', ', \EnumType\JP_ProductType::getValidValues())), __LINE__);
        }
        $this->ProductType = $productType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_MeetingPointListRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
