<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_Inventory StructType
 * @subpackage Structs
 */
class JP_Inventory extends AbstractStructBase
{
    /**
     * The HotelAllotment
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_HotelAllotmentRS[]
     */
    public $HotelAllotment;
    /**
     * The HotelRates
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_HotelRatesRS[]
     */
    public $HotelRates;
    /**
     * The HotelSpecifications
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JPSOAP_HotelInventoryHotel[]
     */
    public $HotelSpecifications;
    /**
     * The HotelListInventory
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_HotelInventorySimpleInfo
     */
    public $HotelListInventory;
    /**
     * Constructor method for JP_Inventory
     * @uses JP_Inventory::setHotelAllotment()
     * @uses JP_Inventory::setHotelRates()
     * @uses JP_Inventory::setHotelSpecifications()
     * @uses JP_Inventory::setHotelListInventory()
     * @param \StructType\JP_HotelAllotmentRS[] $hotelAllotment
     * @param \StructType\JP_HotelRatesRS[] $hotelRates
     * @param \StructType\JPSOAP_HotelInventoryHotel[] $hotelSpecifications
     * @param \ArrayType\ArrayOfJP_HotelInventorySimpleInfo $hotelListInventory
     */
    public function __construct(array $hotelAllotment = array(), array $hotelRates = array(), array $hotelSpecifications = array(), \ArrayType\ArrayOfJP_HotelInventorySimpleInfo $hotelListInventory = null)
    {
        $this
            ->setHotelAllotment($hotelAllotment)
            ->setHotelRates($hotelRates)
            ->setHotelSpecifications($hotelSpecifications)
            ->setHotelListInventory($hotelListInventory);
    }
    /**
     * Get HotelAllotment value
     * @return \StructType\JP_HotelAllotmentRS[]|null
     */
    public function getHotelAllotment()
    {
        return $this->HotelAllotment;
    }
    /**
     * This method is responsible for validating the values passed to the setHotelAllotment method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHotelAllotment method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateHotelAllotmentForArrayConstraintsFromSetHotelAllotment(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $jP_InventoryHotelAllotmentItem) {
            // validation for constraint: itemType
            if (!$jP_InventoryHotelAllotmentItem instanceof \StructType\JP_HotelAllotmentRS) {
                $invalidValues[] = is_object($jP_InventoryHotelAllotmentItem) ? get_class($jP_InventoryHotelAllotmentItem) : sprintf('%s(%s)', gettype($jP_InventoryHotelAllotmentItem), var_export($jP_InventoryHotelAllotmentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The HotelAllotment property can only contain items of type \StructType\JP_HotelAllotmentRS, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set HotelAllotment value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_HotelAllotmentRS[] $hotelAllotment
     * @return \StructType\JP_Inventory
     */
    public function setHotelAllotment(array $hotelAllotment = array())
    {
        // validation for constraint: array
        if ('' !== ($hotelAllotmentArrayErrorMessage = self::validateHotelAllotmentForArrayConstraintsFromSetHotelAllotment($hotelAllotment))) {
            throw new \InvalidArgumentException($hotelAllotmentArrayErrorMessage, __LINE__);
        }
        $this->HotelAllotment = $hotelAllotment;
        return $this;
    }
    /**
     * Add item to HotelAllotment value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_HotelAllotmentRS $item
     * @return \StructType\JP_Inventory
     */
    public function addToHotelAllotment(\StructType\JP_HotelAllotmentRS $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_HotelAllotmentRS) {
            throw new \InvalidArgumentException(sprintf('The HotelAllotment property can only contain items of type \StructType\JP_HotelAllotmentRS, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->HotelAllotment[] = $item;
        return $this;
    }
    /**
     * Get HotelRates value
     * @return \StructType\JP_HotelRatesRS[]|null
     */
    public function getHotelRates()
    {
        return $this->HotelRates;
    }
    /**
     * This method is responsible for validating the values passed to the setHotelRates method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHotelRates method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateHotelRatesForArrayConstraintsFromSetHotelRates(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $jP_InventoryHotelRatesItem) {
            // validation for constraint: itemType
            if (!$jP_InventoryHotelRatesItem instanceof \StructType\JP_HotelRatesRS) {
                $invalidValues[] = is_object($jP_InventoryHotelRatesItem) ? get_class($jP_InventoryHotelRatesItem) : sprintf('%s(%s)', gettype($jP_InventoryHotelRatesItem), var_export($jP_InventoryHotelRatesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The HotelRates property can only contain items of type \StructType\JP_HotelRatesRS, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set HotelRates value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_HotelRatesRS[] $hotelRates
     * @return \StructType\JP_Inventory
     */
    public function setHotelRates(array $hotelRates = array())
    {
        // validation for constraint: array
        if ('' !== ($hotelRatesArrayErrorMessage = self::validateHotelRatesForArrayConstraintsFromSetHotelRates($hotelRates))) {
            throw new \InvalidArgumentException($hotelRatesArrayErrorMessage, __LINE__);
        }
        $this->HotelRates = $hotelRates;
        return $this;
    }
    /**
     * Add item to HotelRates value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_HotelRatesRS $item
     * @return \StructType\JP_Inventory
     */
    public function addToHotelRates(\StructType\JP_HotelRatesRS $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_HotelRatesRS) {
            throw new \InvalidArgumentException(sprintf('The HotelRates property can only contain items of type \StructType\JP_HotelRatesRS, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->HotelRates[] = $item;
        return $this;
    }
    /**
     * Get HotelSpecifications value
     * @return \StructType\JPSOAP_HotelInventoryHotel[]|null
     */
    public function getHotelSpecifications()
    {
        return $this->HotelSpecifications;
    }
    /**
     * This method is responsible for validating the values passed to the setHotelSpecifications method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHotelSpecifications method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateHotelSpecificationsForArrayConstraintsFromSetHotelSpecifications(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $jP_InventoryHotelSpecificationsItem) {
            // validation for constraint: itemType
            if (!$jP_InventoryHotelSpecificationsItem instanceof \StructType\JPSOAP_HotelInventoryHotel) {
                $invalidValues[] = is_object($jP_InventoryHotelSpecificationsItem) ? get_class($jP_InventoryHotelSpecificationsItem) : sprintf('%s(%s)', gettype($jP_InventoryHotelSpecificationsItem), var_export($jP_InventoryHotelSpecificationsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The HotelSpecifications property can only contain items of type \StructType\JPSOAP_HotelInventoryHotel, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set HotelSpecifications value
     * @throws \InvalidArgumentException
     * @param \StructType\JPSOAP_HotelInventoryHotel[] $hotelSpecifications
     * @return \StructType\JP_Inventory
     */
    public function setHotelSpecifications(array $hotelSpecifications = array())
    {
        // validation for constraint: array
        if ('' !== ($hotelSpecificationsArrayErrorMessage = self::validateHotelSpecificationsForArrayConstraintsFromSetHotelSpecifications($hotelSpecifications))) {
            throw new \InvalidArgumentException($hotelSpecificationsArrayErrorMessage, __LINE__);
        }
        $this->HotelSpecifications = $hotelSpecifications;
        return $this;
    }
    /**
     * Add item to HotelSpecifications value
     * @throws \InvalidArgumentException
     * @param \StructType\JPSOAP_HotelInventoryHotel $item
     * @return \StructType\JP_Inventory
     */
    public function addToHotelSpecifications(\StructType\JPSOAP_HotelInventoryHotel $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JPSOAP_HotelInventoryHotel) {
            throw new \InvalidArgumentException(sprintf('The HotelSpecifications property can only contain items of type \StructType\JPSOAP_HotelInventoryHotel, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->HotelSpecifications[] = $item;
        return $this;
    }
    /**
     * Get HotelListInventory value
     * @return \ArrayType\ArrayOfJP_HotelInventorySimpleInfo|null
     */
    public function getHotelListInventory()
    {
        return $this->HotelListInventory;
    }
    /**
     * Set HotelListInventory value
     * @param \ArrayType\ArrayOfJP_HotelInventorySimpleInfo $hotelListInventory
     * @return \StructType\JP_Inventory
     */
    public function setHotelListInventory(\ArrayType\ArrayOfJP_HotelInventorySimpleInfo $hotelListInventory = null)
    {
        $this->HotelListInventory = $hotelListInventory;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_Inventory
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
