<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_HotelListRQ StructType
 * @subpackage Structs
 */
class JP_HotelListRQ extends AbstractStructBase
{
    /**
     * The Login
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_Login
     */
    public $Login;
    /**
     * The HotelListRequest
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_HotelListRequest
     */
    public $HotelListRequest;
    /**
     * The RestrictedOptions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_RestrictedOptions
     */
    public $RestrictedOptions;
    /**
     * The AdvancedOptions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_HotelDataAdvancedOptions
     */
    public $AdvancedOptions;
    /**
     * The Version
     * @var string
     */
    public $Version;
    /**
     * The Language
     * @var string
     */
    public $Language;
    /**
     * Constructor method for JP_HotelListRQ
     * @uses JP_HotelListRQ::setLogin()
     * @uses JP_HotelListRQ::setHotelListRequest()
     * @uses JP_HotelListRQ::setRestrictedOptions()
     * @uses JP_HotelListRQ::setAdvancedOptions()
     * @uses JP_HotelListRQ::setVersion()
     * @uses JP_HotelListRQ::setLanguage()
     * @param \StructType\JP_Login $login
     * @param \StructType\JP_HotelListRequest $hotelListRequest
     * @param \StructType\JP_RestrictedOptions $restrictedOptions
     * @param \StructType\JP_HotelDataAdvancedOptions $advancedOptions
     * @param string $version
     * @param string $language
     */
    public function __construct(\StructType\JP_Login $login = null, \StructType\JP_HotelListRequest $hotelListRequest = null, \StructType\JP_RestrictedOptions $restrictedOptions = null, \StructType\JP_HotelDataAdvancedOptions $advancedOptions = null, $version = null, $language = null)
    {
        $this
            ->setLogin($login)
            ->setHotelListRequest($hotelListRequest)
            ->setRestrictedOptions($restrictedOptions)
            ->setAdvancedOptions($advancedOptions)
            ->setVersion($version)
            ->setLanguage($language);
    }
    /**
     * Get Login value
     * @return \StructType\JP_Login|null
     */
    public function getLogin()
    {
        return $this->Login;
    }
    /**
     * Set Login value
     * @param \StructType\JP_Login $login
     * @return \StructType\JP_HotelListRQ
     */
    public function setLogin(\StructType\JP_Login $login = null)
    {
        $this->Login = $login;
        return $this;
    }
    /**
     * Get HotelListRequest value
     * @return \StructType\JP_HotelListRequest|null
     */
    public function getHotelListRequest()
    {
        return $this->HotelListRequest;
    }
    /**
     * Set HotelListRequest value
     * @param \StructType\JP_HotelListRequest $hotelListRequest
     * @return \StructType\JP_HotelListRQ
     */
    public function setHotelListRequest(\StructType\JP_HotelListRequest $hotelListRequest = null)
    {
        $this->HotelListRequest = $hotelListRequest;
        return $this;
    }
    /**
     * Get RestrictedOptions value
     * @return \StructType\JP_RestrictedOptions|null
     */
    public function getRestrictedOptions()
    {
        return $this->RestrictedOptions;
    }
    /**
     * Set RestrictedOptions value
     * @param \StructType\JP_RestrictedOptions $restrictedOptions
     * @return \StructType\JP_HotelListRQ
     */
    public function setRestrictedOptions(\StructType\JP_RestrictedOptions $restrictedOptions = null)
    {
        $this->RestrictedOptions = $restrictedOptions;
        return $this;
    }
    /**
     * Get AdvancedOptions value
     * @return \StructType\JP_HotelDataAdvancedOptions|null
     */
    public function getAdvancedOptions()
    {
        return $this->AdvancedOptions;
    }
    /**
     * Set AdvancedOptions value
     * @param \StructType\JP_HotelDataAdvancedOptions $advancedOptions
     * @return \StructType\JP_HotelListRQ
     */
    public function setAdvancedOptions(\StructType\JP_HotelDataAdvancedOptions $advancedOptions = null)
    {
        $this->AdvancedOptions = $advancedOptions;
        return $this;
    }
    /**
     * Get Version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param string $version
     * @return \StructType\JP_HotelListRQ
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->Version = $version;
        return $this;
    }
    /**
     * Get Language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->Language;
    }
    /**
     * Set Language value
     * @param string $language
     * @return \StructType\JP_HotelListRQ
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($language, true), gettype($language)), __LINE__);
        }
        $this->Language = $language;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_HotelListRQ
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
