<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_HotelInfo StructType
 * @subpackage Structs
 */
class JP_HotelInfo extends AbstractStructBase
{
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The Images
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString1
     */
    public $Images;
    /**
     * The HotelChain
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_HotelChain
     */
    public $HotelChain;
    /**
     * The HotelCategory
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_HotelCategory
     */
    public $HotelCategory;
    /**
     * The HotelType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_HotelType
     */
    public $HotelType;
    /**
     * The PropertyType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_PropertyType
     */
    public $PropertyType;
    /**
     * The Label
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_LabelType
     */
    public $Label;
    /**
     * The Address
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Address;
    /**
     * The Latitude
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Latitude;
    /**
     * The Longitude
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Longitude;
    /**
     * The DeepLink
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DeepLink;
    /**
     * The ContentProviders
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_ContentProvider
     */
    public $ContentProviders;
    /**
     * The TimeInformation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_HotelTimeInformation
     */
    public $TimeInformation;
    /**
     * Constructor method for JP_HotelInfo
     * @uses JP_HotelInfo::setName()
     * @uses JP_HotelInfo::setDescription()
     * @uses JP_HotelInfo::setImages()
     * @uses JP_HotelInfo::setHotelChain()
     * @uses JP_HotelInfo::setHotelCategory()
     * @uses JP_HotelInfo::setHotelType()
     * @uses JP_HotelInfo::setPropertyType()
     * @uses JP_HotelInfo::setLabel()
     * @uses JP_HotelInfo::setAddress()
     * @uses JP_HotelInfo::setLatitude()
     * @uses JP_HotelInfo::setLongitude()
     * @uses JP_HotelInfo::setDeepLink()
     * @uses JP_HotelInfo::setContentProviders()
     * @uses JP_HotelInfo::setTimeInformation()
     * @param string $name
     * @param string $description
     * @param \ArrayType\ArrayOfString1 $images
     * @param \StructType\JP_HotelChain $hotelChain
     * @param \StructType\JP_HotelCategory $hotelCategory
     * @param \StructType\JP_HotelType $hotelType
     * @param \StructType\JP_PropertyType $propertyType
     * @param \StructType\JP_LabelType $label
     * @param string $address
     * @param string $latitude
     * @param string $longitude
     * @param string $deepLink
     * @param \ArrayType\ArrayOfJP_ContentProvider $contentProviders
     * @param \StructType\JP_HotelTimeInformation $timeInformation
     */
    public function __construct($name = null, $description = null, \ArrayType\ArrayOfString1 $images = null, \StructType\JP_HotelChain $hotelChain = null, \StructType\JP_HotelCategory $hotelCategory = null, \StructType\JP_HotelType $hotelType = null, \StructType\JP_PropertyType $propertyType = null, \StructType\JP_LabelType $label = null, $address = null, $latitude = null, $longitude = null, $deepLink = null, \ArrayType\ArrayOfJP_ContentProvider $contentProviders = null, \StructType\JP_HotelTimeInformation $timeInformation = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setImages($images)
            ->setHotelChain($hotelChain)
            ->setHotelCategory($hotelCategory)
            ->setHotelType($hotelType)
            ->setPropertyType($propertyType)
            ->setLabel($label)
            ->setAddress($address)
            ->setLatitude($latitude)
            ->setLongitude($longitude)
            ->setDeepLink($deepLink)
            ->setContentProviders($contentProviders)
            ->setTimeInformation($timeInformation);
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\JP_HotelInfo
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\JP_HotelInfo
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Images value
     * @return \ArrayType\ArrayOfString1|null
     */
    public function getImages()
    {
        return $this->Images;
    }
    /**
     * Set Images value
     * @param \ArrayType\ArrayOfString1 $images
     * @return \StructType\JP_HotelInfo
     */
    public function setImages(\ArrayType\ArrayOfString1 $images = null)
    {
        $this->Images = $images;
        return $this;
    }
    /**
     * Get HotelChain value
     * @return \StructType\JP_HotelChain|null
     */
    public function getHotelChain()
    {
        return $this->HotelChain;
    }
    /**
     * Set HotelChain value
     * @param \StructType\JP_HotelChain $hotelChain
     * @return \StructType\JP_HotelInfo
     */
    public function setHotelChain(\StructType\JP_HotelChain $hotelChain = null)
    {
        $this->HotelChain = $hotelChain;
        return $this;
    }
    /**
     * Get HotelCategory value
     * @return \StructType\JP_HotelCategory|null
     */
    public function getHotelCategory()
    {
        return $this->HotelCategory;
    }
    /**
     * Set HotelCategory value
     * @param \StructType\JP_HotelCategory $hotelCategory
     * @return \StructType\JP_HotelInfo
     */
    public function setHotelCategory(\StructType\JP_HotelCategory $hotelCategory = null)
    {
        $this->HotelCategory = $hotelCategory;
        return $this;
    }
    /**
     * Get HotelType value
     * @return \StructType\JP_HotelType|null
     */
    public function getHotelType()
    {
        return $this->HotelType;
    }
    /**
     * Set HotelType value
     * @param \StructType\JP_HotelType $hotelType
     * @return \StructType\JP_HotelInfo
     */
    public function setHotelType(\StructType\JP_HotelType $hotelType = null)
    {
        $this->HotelType = $hotelType;
        return $this;
    }
    /**
     * Get PropertyType value
     * @return \StructType\JP_PropertyType|null
     */
    public function getPropertyType()
    {
        return $this->PropertyType;
    }
    /**
     * Set PropertyType value
     * @param \StructType\JP_PropertyType $propertyType
     * @return \StructType\JP_HotelInfo
     */
    public function setPropertyType(\StructType\JP_PropertyType $propertyType = null)
    {
        $this->PropertyType = $propertyType;
        return $this;
    }
    /**
     * Get Label value
     * @return \StructType\JP_LabelType|null
     */
    public function getLabel()
    {
        return $this->Label;
    }
    /**
     * Set Label value
     * @param \StructType\JP_LabelType $label
     * @return \StructType\JP_HotelInfo
     */
    public function setLabel(\StructType\JP_LabelType $label = null)
    {
        $this->Label = $label;
        return $this;
    }
    /**
     * Get Address value
     * @return string|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param string $address
     * @return \StructType\JP_HotelInfo
     */
    public function setAddress($address = null)
    {
        // validation for constraint: string
        if (!is_null($address) && !is_string($address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address, true), gettype($address)), __LINE__);
        }
        $this->Address = $address;
        return $this;
    }
    /**
     * Get Latitude value
     * @return string|null
     */
    public function getLatitude()
    {
        return $this->Latitude;
    }
    /**
     * Set Latitude value
     * @param string $latitude
     * @return \StructType\JP_HotelInfo
     */
    public function setLatitude($latitude = null)
    {
        // validation for constraint: string
        if (!is_null($latitude) && !is_string($latitude)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($latitude, true), gettype($latitude)), __LINE__);
        }
        $this->Latitude = $latitude;
        return $this;
    }
    /**
     * Get Longitude value
     * @return string|null
     */
    public function getLongitude()
    {
        return $this->Longitude;
    }
    /**
     * Set Longitude value
     * @param string $longitude
     * @return \StructType\JP_HotelInfo
     */
    public function setLongitude($longitude = null)
    {
        // validation for constraint: string
        if (!is_null($longitude) && !is_string($longitude)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($longitude, true), gettype($longitude)), __LINE__);
        }
        $this->Longitude = $longitude;
        return $this;
    }
    /**
     * Get DeepLink value
     * @return string|null
     */
    public function getDeepLink()
    {
        return $this->DeepLink;
    }
    /**
     * Set DeepLink value
     * @param string $deepLink
     * @return \StructType\JP_HotelInfo
     */
    public function setDeepLink($deepLink = null)
    {
        // validation for constraint: string
        if (!is_null($deepLink) && !is_string($deepLink)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deepLink, true), gettype($deepLink)), __LINE__);
        }
        $this->DeepLink = $deepLink;
        return $this;
    }
    /**
     * Get ContentProviders value
     * @return \ArrayType\ArrayOfJP_ContentProvider|null
     */
    public function getContentProviders()
    {
        return $this->ContentProviders;
    }
    /**
     * Set ContentProviders value
     * @param \ArrayType\ArrayOfJP_ContentProvider $contentProviders
     * @return \StructType\JP_HotelInfo
     */
    public function setContentProviders(\ArrayType\ArrayOfJP_ContentProvider $contentProviders = null)
    {
        $this->ContentProviders = $contentProviders;
        return $this;
    }
    /**
     * Get TimeInformation value
     * @return \StructType\JP_HotelTimeInformation|null
     */
    public function getTimeInformation()
    {
        return $this->TimeInformation;
    }
    /**
     * Set TimeInformation value
     * @param \StructType\JP_HotelTimeInformation $timeInformation
     * @return \StructType\JP_HotelInfo
     */
    public function setTimeInformation(\StructType\JP_HotelTimeInformation $timeInformation = null)
    {
        $this->TimeInformation = $timeInformation;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_HotelInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
