<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_BaseItem StructType
 * @subpackage Structs
 */
abstract class JP_BaseItem extends AbstractStructBase
{
    /**
     * The ExternalInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_ExternalInfo
     */
    public $ExternalInfo;
    /**
     * The Prices
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_Price
     */
    public $Prices;
    /**
     * The CancellationPolicy
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_CancellationPolicyRules
     */
    public $CancellationPolicy;
    /**
     * The CancellationPolicyCost
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_CancellationPolicyRules
     */
    public $CancellationPolicyCost;
    /**
     * The Comments
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_Comment
     */
    public $Comments;
    /**
     * The Modifications
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_ModificationInfo
     */
    public $Modifications;
    /**
     * The ItemId
     * @var string
     */
    public $ItemId;
    /**
     * The Status
     * @var string
     */
    public $Status;
    /**
     * Constructor method for JP_BaseItem
     * @uses JP_BaseItem::setExternalInfo()
     * @uses JP_BaseItem::setPrices()
     * @uses JP_BaseItem::setCancellationPolicy()
     * @uses JP_BaseItem::setCancellationPolicyCost()
     * @uses JP_BaseItem::setComments()
     * @uses JP_BaseItem::setModifications()
     * @uses JP_BaseItem::setItemId()
     * @uses JP_BaseItem::setStatus()
     * @param \StructType\JP_ExternalInfo $externalInfo
     * @param \ArrayType\ArrayOfJP_Price $prices
     * @param \StructType\JP_CancellationPolicyRules $cancellationPolicy
     * @param \StructType\JP_CancellationPolicyRules $cancellationPolicyCost
     * @param \ArrayType\ArrayOfJP_Comment $comments
     * @param \StructType\JP_ModificationInfo $modifications
     * @param string $itemId
     * @param string $status
     */
    public function __construct(\StructType\JP_ExternalInfo $externalInfo = null, \ArrayType\ArrayOfJP_Price $prices = null, \StructType\JP_CancellationPolicyRules $cancellationPolicy = null, \StructType\JP_CancellationPolicyRules $cancellationPolicyCost = null, \ArrayType\ArrayOfJP_Comment $comments = null, \StructType\JP_ModificationInfo $modifications = null, $itemId = null, $status = null)
    {
        $this
            ->setExternalInfo($externalInfo)
            ->setPrices($prices)
            ->setCancellationPolicy($cancellationPolicy)
            ->setCancellationPolicyCost($cancellationPolicyCost)
            ->setComments($comments)
            ->setModifications($modifications)
            ->setItemId($itemId)
            ->setStatus($status);
    }
    /**
     * Get ExternalInfo value
     * @return \StructType\JP_ExternalInfo|null
     */
    public function getExternalInfo()
    {
        return $this->ExternalInfo;
    }
    /**
     * Set ExternalInfo value
     * @param \StructType\JP_ExternalInfo $externalInfo
     * @return \StructType\JP_BaseItem
     */
    public function setExternalInfo(\StructType\JP_ExternalInfo $externalInfo = null)
    {
        $this->ExternalInfo = $externalInfo;
        return $this;
    }
    /**
     * Get Prices value
     * @return \ArrayType\ArrayOfJP_Price|null
     */
    public function getPrices()
    {
        return $this->Prices;
    }
    /**
     * Set Prices value
     * @param \ArrayType\ArrayOfJP_Price $prices
     * @return \StructType\JP_BaseItem
     */
    public function setPrices(\ArrayType\ArrayOfJP_Price $prices = null)
    {
        $this->Prices = $prices;
        return $this;
    }
    /**
     * Get CancellationPolicy value
     * @return \StructType\JP_CancellationPolicyRules|null
     */
    public function getCancellationPolicy()
    {
        return $this->CancellationPolicy;
    }
    /**
     * Set CancellationPolicy value
     * @param \StructType\JP_CancellationPolicyRules $cancellationPolicy
     * @return \StructType\JP_BaseItem
     */
    public function setCancellationPolicy(\StructType\JP_CancellationPolicyRules $cancellationPolicy = null)
    {
        $this->CancellationPolicy = $cancellationPolicy;
        return $this;
    }
    /**
     * Get CancellationPolicyCost value
     * @return \StructType\JP_CancellationPolicyRules|null
     */
    public function getCancellationPolicyCost()
    {
        return $this->CancellationPolicyCost;
    }
    /**
     * Set CancellationPolicyCost value
     * @param \StructType\JP_CancellationPolicyRules $cancellationPolicyCost
     * @return \StructType\JP_BaseItem
     */
    public function setCancellationPolicyCost(\StructType\JP_CancellationPolicyRules $cancellationPolicyCost = null)
    {
        $this->CancellationPolicyCost = $cancellationPolicyCost;
        return $this;
    }
    /**
     * Get Comments value
     * @return \ArrayType\ArrayOfJP_Comment|null
     */
    public function getComments()
    {
        return $this->Comments;
    }
    /**
     * Set Comments value
     * @param \ArrayType\ArrayOfJP_Comment $comments
     * @return \StructType\JP_BaseItem
     */
    public function setComments(\ArrayType\ArrayOfJP_Comment $comments = null)
    {
        $this->Comments = $comments;
        return $this;
    }
    /**
     * Get Modifications value
     * @return \StructType\JP_ModificationInfo|null
     */
    public function getModifications()
    {
        return $this->Modifications;
    }
    /**
     * Set Modifications value
     * @param \StructType\JP_ModificationInfo $modifications
     * @return \StructType\JP_BaseItem
     */
    public function setModifications(\StructType\JP_ModificationInfo $modifications = null)
    {
        $this->Modifications = $modifications;
        return $this;
    }
    /**
     * Get ItemId value
     * @return string|null
     */
    public function getItemId()
    {
        return $this->ItemId;
    }
    /**
     * Set ItemId value
     * @param string $itemId
     * @return \StructType\JP_BaseItem
     */
    public function setItemId($itemId = null)
    {
        // validation for constraint: string
        if (!is_null($itemId) && !is_string($itemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemId, true), gettype($itemId)), __LINE__);
        }
        $this->ItemId = $itemId;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \EnumType\JP_ItemStatus::valueIsValid()
     * @uses \EnumType\JP_ItemStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\JP_BaseItem
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JP_ItemStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JP_ItemStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \EnumType\JP_ItemStatus::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_BaseItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
