<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_BaseElement StructType
 * @subpackage Structs
 */
abstract class JP_BaseElement extends AbstractStructBase
{
    /**
     * The BookingCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_BookingCode
     */
    public $BookingCode;
    /**
     * The ExternalItemReference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ExternalItemReference;
    /**
     * The RelPaxesDist
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_RelPaxDist
     */
    public $RelPaxesDist;
    /**
     * The Comments
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_Comment
     */
    public $Comments;
    /**
     * The CreditCard
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_CreditCardInfo
     */
    public $CreditCard;
    /**
     * The ElementId
     * @var string
     */
    public $ElementId;
    /**
     * Constructor method for JP_BaseElement
     * @uses JP_BaseElement::setBookingCode()
     * @uses JP_BaseElement::setExternalItemReference()
     * @uses JP_BaseElement::setRelPaxesDist()
     * @uses JP_BaseElement::setComments()
     * @uses JP_BaseElement::setCreditCard()
     * @uses JP_BaseElement::setElementId()
     * @param \StructType\JP_BookingCode $bookingCode
     * @param string $externalItemReference
     * @param \ArrayType\ArrayOfJP_RelPaxDist $relPaxesDist
     * @param \ArrayType\ArrayOfJP_Comment $comments
     * @param \StructType\JP_CreditCardInfo $creditCard
     * @param string $elementId
     */
    public function __construct(\StructType\JP_BookingCode $bookingCode = null, $externalItemReference = null, \ArrayType\ArrayOfJP_RelPaxDist $relPaxesDist = null, \ArrayType\ArrayOfJP_Comment $comments = null, \StructType\JP_CreditCardInfo $creditCard = null, $elementId = null)
    {
        $this
            ->setBookingCode($bookingCode)
            ->setExternalItemReference($externalItemReference)
            ->setRelPaxesDist($relPaxesDist)
            ->setComments($comments)
            ->setCreditCard($creditCard)
            ->setElementId($elementId);
    }
    /**
     * Get BookingCode value
     * @return \StructType\JP_BookingCode|null
     */
    public function getBookingCode()
    {
        return $this->BookingCode;
    }
    /**
     * Set BookingCode value
     * @param \StructType\JP_BookingCode $bookingCode
     * @return \StructType\JP_BaseElement
     */
    public function setBookingCode(\StructType\JP_BookingCode $bookingCode = null)
    {
        $this->BookingCode = $bookingCode;
        return $this;
    }
    /**
     * Get ExternalItemReference value
     * @return string|null
     */
    public function getExternalItemReference()
    {
        return $this->ExternalItemReference;
    }
    /**
     * Set ExternalItemReference value
     * @param string $externalItemReference
     * @return \StructType\JP_BaseElement
     */
    public function setExternalItemReference($externalItemReference = null)
    {
        // validation for constraint: string
        if (!is_null($externalItemReference) && !is_string($externalItemReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalItemReference, true), gettype($externalItemReference)), __LINE__);
        }
        $this->ExternalItemReference = $externalItemReference;
        return $this;
    }
    /**
     * Get RelPaxesDist value
     * @return \ArrayType\ArrayOfJP_RelPaxDist|null
     */
    public function getRelPaxesDist()
    {
        return $this->RelPaxesDist;
    }
    /**
     * Set RelPaxesDist value
     * @param \ArrayType\ArrayOfJP_RelPaxDist $relPaxesDist
     * @return \StructType\JP_BaseElement
     */
    public function setRelPaxesDist(\ArrayType\ArrayOfJP_RelPaxDist $relPaxesDist = null)
    {
        $this->RelPaxesDist = $relPaxesDist;
        return $this;
    }
    /**
     * Get Comments value
     * @return \ArrayType\ArrayOfJP_Comment|null
     */
    public function getComments()
    {
        return $this->Comments;
    }
    /**
     * Set Comments value
     * @param \ArrayType\ArrayOfJP_Comment $comments
     * @return \StructType\JP_BaseElement
     */
    public function setComments(\ArrayType\ArrayOfJP_Comment $comments = null)
    {
        $this->Comments = $comments;
        return $this;
    }
    /**
     * Get CreditCard value
     * @return \StructType\JP_CreditCardInfo|null
     */
    public function getCreditCard()
    {
        return $this->CreditCard;
    }
    /**
     * Set CreditCard value
     * @param \StructType\JP_CreditCardInfo $creditCard
     * @return \StructType\JP_BaseElement
     */
    public function setCreditCard(\StructType\JP_CreditCardInfo $creditCard = null)
    {
        $this->CreditCard = $creditCard;
        return $this;
    }
    /**
     * Get ElementId value
     * @return string|null
     */
    public function getElementId()
    {
        return $this->ElementId;
    }
    /**
     * Set ElementId value
     * @param string $elementId
     * @return \StructType\JP_BaseElement
     */
    public function setElementId($elementId = null)
    {
        // validation for constraint: string
        if (!is_null($elementId) && !is_string($elementId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($elementId, true), gettype($elementId)), __LINE__);
        }
        $this->ElementId = $elementId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_BaseElement
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
