<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JPSOAP_ContractRestrictions StructType
 * @subpackage Structs
 */
class JPSOAP_ContractRestrictions extends AbstractStructBase
{
    /**
     * The Application
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Application;
    /**
     * The RequiredOptionalSupplements
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JPSOAP_RequiredOptionalSupplements
     */
    public $RequiredOptionalSupplements;
    /**
     * The CountryOfResidence
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JPSOAP_CountryOfResidence
     */
    public $CountryOfResidence;
    /**
     * The MinNights
     * @var int
     */
    public $MinNights;
    /**
     * The MaxNights
     * @var int
     */
    public $MaxNights;
    /**
     * The MinAdults
     * @var int
     */
    public $MinAdults;
    /**
     * The BookingFrom
     * @var string
     */
    public $BookingFrom;
    /**
     * The BookingTo
     * @var string
     */
    public $BookingTo;
    /**
     * Constructor method for JPSOAP_ContractRestrictions
     * @uses JPSOAP_ContractRestrictions::setApplication()
     * @uses JPSOAP_ContractRestrictions::setRequiredOptionalSupplements()
     * @uses JPSOAP_ContractRestrictions::setCountryOfResidence()
     * @uses JPSOAP_ContractRestrictions::setMinNights()
     * @uses JPSOAP_ContractRestrictions::setMaxNights()
     * @uses JPSOAP_ContractRestrictions::setMinAdults()
     * @uses JPSOAP_ContractRestrictions::setBookingFrom()
     * @uses JPSOAP_ContractRestrictions::setBookingTo()
     * @param string $application
     * @param \StructType\JPSOAP_RequiredOptionalSupplements $requiredOptionalSupplements
     * @param \StructType\JPSOAP_CountryOfResidence $countryOfResidence
     * @param int $minNights
     * @param int $maxNights
     * @param int $minAdults
     * @param string $bookingFrom
     * @param string $bookingTo
     */
    public function __construct($application = null, \StructType\JPSOAP_RequiredOptionalSupplements $requiredOptionalSupplements = null, \StructType\JPSOAP_CountryOfResidence $countryOfResidence = null, $minNights = null, $maxNights = null, $minAdults = null, $bookingFrom = null, $bookingTo = null)
    {
        $this
            ->setApplication($application)
            ->setRequiredOptionalSupplements($requiredOptionalSupplements)
            ->setCountryOfResidence($countryOfResidence)
            ->setMinNights($minNights)
            ->setMaxNights($maxNights)
            ->setMinAdults($minAdults)
            ->setBookingFrom($bookingFrom)
            ->setBookingTo($bookingTo);
    }
    /**
     * Get Application value
     * @return string
     */
    public function getApplication()
    {
        return $this->Application;
    }
    /**
     * Set Application value
     * @uses \EnumType\JPSOAP_ContractRestrictionApplication::valueIsValid()
     * @uses \EnumType\JPSOAP_ContractRestrictionApplication::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $application
     * @return \StructType\JPSOAP_ContractRestrictions
     */
    public function setApplication($application = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JPSOAP_ContractRestrictionApplication::valueIsValid($application)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JPSOAP_ContractRestrictionApplication', is_array($application) ? implode(', ', $application) : var_export($application, true), implode(', ', \EnumType\JPSOAP_ContractRestrictionApplication::getValidValues())), __LINE__);
        }
        $this->Application = $application;
        return $this;
    }
    /**
     * Get RequiredOptionalSupplements value
     * @return \StructType\JPSOAP_RequiredOptionalSupplements|null
     */
    public function getRequiredOptionalSupplements()
    {
        return $this->RequiredOptionalSupplements;
    }
    /**
     * Set RequiredOptionalSupplements value
     * @param \StructType\JPSOAP_RequiredOptionalSupplements $requiredOptionalSupplements
     * @return \StructType\JPSOAP_ContractRestrictions
     */
    public function setRequiredOptionalSupplements(\StructType\JPSOAP_RequiredOptionalSupplements $requiredOptionalSupplements = null)
    {
        $this->RequiredOptionalSupplements = $requiredOptionalSupplements;
        return $this;
    }
    /**
     * Get CountryOfResidence value
     * @return \StructType\JPSOAP_CountryOfResidence|null
     */
    public function getCountryOfResidence()
    {
        return $this->CountryOfResidence;
    }
    /**
     * Set CountryOfResidence value
     * @param \StructType\JPSOAP_CountryOfResidence $countryOfResidence
     * @return \StructType\JPSOAP_ContractRestrictions
     */
    public function setCountryOfResidence(\StructType\JPSOAP_CountryOfResidence $countryOfResidence = null)
    {
        $this->CountryOfResidence = $countryOfResidence;
        return $this;
    }
    /**
     * Get MinNights value
     * @return int|null
     */
    public function getMinNights()
    {
        return $this->MinNights;
    }
    /**
     * Set MinNights value
     * @param int $minNights
     * @return \StructType\JPSOAP_ContractRestrictions
     */
    public function setMinNights($minNights = null)
    {
        // validation for constraint: int
        if (!is_null($minNights) && !(is_int($minNights) || ctype_digit($minNights))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minNights, true), gettype($minNights)), __LINE__);
        }
        $this->MinNights = $minNights;
        return $this;
    }
    /**
     * Get MaxNights value
     * @return int|null
     */
    public function getMaxNights()
    {
        return $this->MaxNights;
    }
    /**
     * Set MaxNights value
     * @param int $maxNights
     * @return \StructType\JPSOAP_ContractRestrictions
     */
    public function setMaxNights($maxNights = null)
    {
        // validation for constraint: int
        if (!is_null($maxNights) && !(is_int($maxNights) || ctype_digit($maxNights))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxNights, true), gettype($maxNights)), __LINE__);
        }
        $this->MaxNights = $maxNights;
        return $this;
    }
    /**
     * Get MinAdults value
     * @return int|null
     */
    public function getMinAdults()
    {
        return $this->MinAdults;
    }
    /**
     * Set MinAdults value
     * @param int $minAdults
     * @return \StructType\JPSOAP_ContractRestrictions
     */
    public function setMinAdults($minAdults = null)
    {
        // validation for constraint: int
        if (!is_null($minAdults) && !(is_int($minAdults) || ctype_digit($minAdults))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minAdults, true), gettype($minAdults)), __LINE__);
        }
        $this->MinAdults = $minAdults;
        return $this;
    }
    /**
     * Get BookingFrom value
     * @return string|null
     */
    public function getBookingFrom()
    {
        return $this->BookingFrom;
    }
    /**
     * Set BookingFrom value
     * @param string $bookingFrom
     * @return \StructType\JPSOAP_ContractRestrictions
     */
    public function setBookingFrom($bookingFrom = null)
    {
        // validation for constraint: string
        if (!is_null($bookingFrom) && !is_string($bookingFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bookingFrom, true), gettype($bookingFrom)), __LINE__);
        }
        $this->BookingFrom = $bookingFrom;
        return $this;
    }
    /**
     * Get BookingTo value
     * @return string|null
     */
    public function getBookingTo()
    {
        return $this->BookingTo;
    }
    /**
     * Set BookingTo value
     * @param string $bookingTo
     * @return \StructType\JPSOAP_ContractRestrictions
     */
    public function setBookingTo($bookingTo = null)
    {
        // validation for constraint: string
        if (!is_null($bookingTo) && !is_string($bookingTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bookingTo, true), gettype($bookingTo)), __LINE__);
        }
        $this->BookingTo = $bookingTo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JPSOAP_ContractRestrictions
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
