<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfJP_ServiceDate ArrayType
 * @subpackage Arrays
 */
class ArrayOfJP_ServiceDate extends AbstractStructArrayBase
{
    /**
     * The Date
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_ServiceDate[]
     */
    public $Date;
    /**
     * Constructor method for ArrayOfJP_ServiceDate
     * @uses ArrayOfJP_ServiceDate::setDate()
     * @param \StructType\JP_ServiceDate[] $date
     */
    public function __construct(array $date = array())
    {
        $this
            ->setDate($date);
    }
    /**
     * Get Date value
     * @return \StructType\JP_ServiceDate[]|null
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * This method is responsible for validating the values passed to the setDate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDate method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDateForArrayConstraintsFromSetDate(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfJP_ServiceDateDateItem) {
            // validation for constraint: itemType
            if (!$arrayOfJP_ServiceDateDateItem instanceof \StructType\JP_ServiceDate) {
                $invalidValues[] = is_object($arrayOfJP_ServiceDateDateItem) ? get_class($arrayOfJP_ServiceDateDateItem) : sprintf('%s(%s)', gettype($arrayOfJP_ServiceDateDateItem), var_export($arrayOfJP_ServiceDateDateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Date property can only contain items of type \StructType\JP_ServiceDate, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Date value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_ServiceDate[] $date
     * @return \ArrayType\ArrayOfJP_ServiceDate
     */
    public function setDate(array $date = array())
    {
        // validation for constraint: array
        if ('' !== ($dateArrayErrorMessage = self::validateDateForArrayConstraintsFromSetDate($date))) {
            throw new \InvalidArgumentException($dateArrayErrorMessage, __LINE__);
        }
        $this->Date = $date;
        return $this;
    }
    /**
     * Add item to Date value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_ServiceDate $item
     * @return \ArrayType\ArrayOfJP_ServiceDate
     */
    public function addToDate(\StructType\JP_ServiceDate $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_ServiceDate) {
            throw new \InvalidArgumentException(sprintf('The Date property can only contain items of type \StructType\JP_ServiceDate, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Date[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\JP_ServiceDate|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\JP_ServiceDate|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\JP_ServiceDate|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\JP_ServiceDate|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\JP_ServiceDate|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Date
     */
    public function getAttributeName()
    {
        return 'Date';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfJP_ServiceDate
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
