<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfJP_Rule ArrayType
 * @subpackage Arrays
 */
class ArrayOfJP_Rule extends AbstractStructArrayBase
{
    /**
     * The Rule
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_Rule[]
     */
    public $Rule;
    /**
     * Constructor method for ArrayOfJP_Rule
     * @uses ArrayOfJP_Rule::setRule()
     * @param \StructType\JP_Rule[] $rule
     */
    public function __construct(array $rule = array())
    {
        $this
            ->setRule($rule);
    }
    /**
     * Get Rule value
     * @return \StructType\JP_Rule[]|null
     */
    public function getRule()
    {
        return $this->Rule;
    }
    /**
     * This method is responsible for validating the values passed to the setRule method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRule method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRuleForArrayConstraintsFromSetRule(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfJP_RuleRuleItem) {
            // validation for constraint: itemType
            if (!$arrayOfJP_RuleRuleItem instanceof \StructType\JP_Rule) {
                $invalidValues[] = is_object($arrayOfJP_RuleRuleItem) ? get_class($arrayOfJP_RuleRuleItem) : sprintf('%s(%s)', gettype($arrayOfJP_RuleRuleItem), var_export($arrayOfJP_RuleRuleItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Rule property can only contain items of type \StructType\JP_Rule, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Rule value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_Rule[] $rule
     * @return \ArrayType\ArrayOfJP_Rule
     */
    public function setRule(array $rule = array())
    {
        // validation for constraint: array
        if ('' !== ($ruleArrayErrorMessage = self::validateRuleForArrayConstraintsFromSetRule($rule))) {
            throw new \InvalidArgumentException($ruleArrayErrorMessage, __LINE__);
        }
        $this->Rule = $rule;
        return $this;
    }
    /**
     * Add item to Rule value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_Rule $item
     * @return \ArrayType\ArrayOfJP_Rule
     */
    public function addToRule(\StructType\JP_Rule $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_Rule) {
            throw new \InvalidArgumentException(sprintf('The Rule property can only contain items of type \StructType\JP_Rule, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Rule[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\JP_Rule|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\JP_Rule|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\JP_Rule|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\JP_Rule|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\JP_Rule|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Rule
     */
    public function getAttributeName()
    {
        return 'Rule';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfJP_Rule
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
