<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfJP_HotelOption ArrayType
 * @subpackage Arrays
 */
class ArrayOfJP_HotelOption extends AbstractStructArrayBase
{
    /**
     * The HotelOption
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_HotelOption[]
     */
    public $HotelOption;
    /**
     * Constructor method for ArrayOfJP_HotelOption
     * @uses ArrayOfJP_HotelOption::setHotelOption()
     * @param \StructType\JP_HotelOption[] $hotelOption
     */
    public function __construct(array $hotelOption = array())
    {
        $this
            ->setHotelOption($hotelOption);
    }
    /**
     * Get HotelOption value
     * @return \StructType\JP_HotelOption[]|null
     */
    public function getHotelOption()
    {
        return $this->HotelOption;
    }
    /**
     * This method is responsible for validating the values passed to the setHotelOption method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHotelOption method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateHotelOptionForArrayConstraintsFromSetHotelOption(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfJP_HotelOptionHotelOptionItem) {
            // validation for constraint: itemType
            if (!$arrayOfJP_HotelOptionHotelOptionItem instanceof \StructType\JP_HotelOption) {
                $invalidValues[] = is_object($arrayOfJP_HotelOptionHotelOptionItem) ? get_class($arrayOfJP_HotelOptionHotelOptionItem) : sprintf('%s(%s)', gettype($arrayOfJP_HotelOptionHotelOptionItem), var_export($arrayOfJP_HotelOptionHotelOptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The HotelOption property can only contain items of type \StructType\JP_HotelOption, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set HotelOption value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_HotelOption[] $hotelOption
     * @return \ArrayType\ArrayOfJP_HotelOption
     */
    public function setHotelOption(array $hotelOption = array())
    {
        // validation for constraint: array
        if ('' !== ($hotelOptionArrayErrorMessage = self::validateHotelOptionForArrayConstraintsFromSetHotelOption($hotelOption))) {
            throw new \InvalidArgumentException($hotelOptionArrayErrorMessage, __LINE__);
        }
        $this->HotelOption = $hotelOption;
        return $this;
    }
    /**
     * Add item to HotelOption value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_HotelOption $item
     * @return \ArrayType\ArrayOfJP_HotelOption
     */
    public function addToHotelOption(\StructType\JP_HotelOption $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_HotelOption) {
            throw new \InvalidArgumentException(sprintf('The HotelOption property can only contain items of type \StructType\JP_HotelOption, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->HotelOption[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\JP_HotelOption|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\JP_HotelOption|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\JP_HotelOption|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\JP_HotelOption|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\JP_HotelOption|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string HotelOption
     */
    public function getAttributeName()
    {
        return 'HotelOption';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfJP_HotelOption
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
