<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfJP_FlightTicketInfo ArrayType
 * @subpackage Arrays
 */
class ArrayOfJP_FlightTicketInfo extends AbstractStructArrayBase
{
    /**
     * The Flight
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_FlightTicketInfo[]
     */
    public $Flight;
    /**
     * Constructor method for ArrayOfJP_FlightTicketInfo
     * @uses ArrayOfJP_FlightTicketInfo::setFlight()
     * @param \StructType\JP_FlightTicketInfo[] $flight
     */
    public function __construct(array $flight = array())
    {
        $this
            ->setFlight($flight);
    }
    /**
     * Get Flight value
     * @return \StructType\JP_FlightTicketInfo[]|null
     */
    public function getFlight()
    {
        return $this->Flight;
    }
    /**
     * This method is responsible for validating the values passed to the setFlight method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFlight method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFlightForArrayConstraintsFromSetFlight(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfJP_FlightTicketInfoFlightItem) {
            // validation for constraint: itemType
            if (!$arrayOfJP_FlightTicketInfoFlightItem instanceof \StructType\JP_FlightTicketInfo) {
                $invalidValues[] = is_object($arrayOfJP_FlightTicketInfoFlightItem) ? get_class($arrayOfJP_FlightTicketInfoFlightItem) : sprintf('%s(%s)', gettype($arrayOfJP_FlightTicketInfoFlightItem), var_export($arrayOfJP_FlightTicketInfoFlightItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Flight property can only contain items of type \StructType\JP_FlightTicketInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Flight value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_FlightTicketInfo[] $flight
     * @return \ArrayType\ArrayOfJP_FlightTicketInfo
     */
    public function setFlight(array $flight = array())
    {
        // validation for constraint: array
        if ('' !== ($flightArrayErrorMessage = self::validateFlightForArrayConstraintsFromSetFlight($flight))) {
            throw new \InvalidArgumentException($flightArrayErrorMessage, __LINE__);
        }
        $this->Flight = $flight;
        return $this;
    }
    /**
     * Add item to Flight value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_FlightTicketInfo $item
     * @return \ArrayType\ArrayOfJP_FlightTicketInfo
     */
    public function addToFlight(\StructType\JP_FlightTicketInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_FlightTicketInfo) {
            throw new \InvalidArgumentException(sprintf('The Flight property can only contain items of type \StructType\JP_FlightTicketInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Flight[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\JP_FlightTicketInfo|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\JP_FlightTicketInfo|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\JP_FlightTicketInfo|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\JP_FlightTicketInfo|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\JP_FlightTicketInfo|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Flight
     */
    public function getAttributeName()
    {
        return 'Flight';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfJP_FlightTicketInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
