<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_TransferDestination StructType
 * @subpackage Structs
 */
class JP_TransferDestination extends AbstractStructBase
{
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Type;
    /**
     * The MeetingPointInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_MeetingPointInfo
     */
    public $MeetingPointInfo;
    /**
     * The FlightInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_FlightInfo
     */
    public $FlightInfo;
    /**
     * The ShipInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_ShipInfo
     */
    public $ShipInfo;
    /**
     * The TrainInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_TrainInfo
     */
    public $TrainInfo;
    /**
     * The TerminalDeparture
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TerminalDeparture;
    /**
     * The TerminalArrival
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TerminalArrival;
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * The Start
     * @var string
     */
    public $Start;
    /**
     * The MeetingTime
     * @var string
     */
    public $MeetingTime;
    /**
     * The HotelCode
     * @var string
     */
    public $HotelCode;
    /**
     * Constructor method for JP_TransferDestination
     * @uses JP_TransferDestination::setType()
     * @uses JP_TransferDestination::setMeetingPointInfo()
     * @uses JP_TransferDestination::setFlightInfo()
     * @uses JP_TransferDestination::setShipInfo()
     * @uses JP_TransferDestination::setTrainInfo()
     * @uses JP_TransferDestination::setTerminalDeparture()
     * @uses JP_TransferDestination::setTerminalArrival()
     * @uses JP_TransferDestination::setCode()
     * @uses JP_TransferDestination::setStart()
     * @uses JP_TransferDestination::setMeetingTime()
     * @uses JP_TransferDestination::setHotelCode()
     * @param string $type
     * @param \StructType\JP_MeetingPointInfo $meetingPointInfo
     * @param \StructType\JP_FlightInfo $flightInfo
     * @param \StructType\JP_ShipInfo $shipInfo
     * @param \StructType\JP_TrainInfo $trainInfo
     * @param string $terminalDeparture
     * @param string $terminalArrival
     * @param string $code
     * @param string $start
     * @param string $meetingTime
     * @param string $hotelCode
     */
    public function __construct($type = null, \StructType\JP_MeetingPointInfo $meetingPointInfo = null, \StructType\JP_FlightInfo $flightInfo = null, \StructType\JP_ShipInfo $shipInfo = null, \StructType\JP_TrainInfo $trainInfo = null, $terminalDeparture = null, $terminalArrival = null, $code = null, $start = null, $meetingTime = null, $hotelCode = null)
    {
        $this
            ->setType($type)
            ->setMeetingPointInfo($meetingPointInfo)
            ->setFlightInfo($flightInfo)
            ->setShipInfo($shipInfo)
            ->setTrainInfo($trainInfo)
            ->setTerminalDeparture($terminalDeparture)
            ->setTerminalArrival($terminalArrival)
            ->setCode($code)
            ->setStart($start)
            ->setMeetingTime($meetingTime)
            ->setHotelCode($hotelCode);
    }
    /**
     * Get Type value
     * @return string
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \EnumType\JP_ZoneType::valueIsValid()
     * @uses \EnumType\JP_ZoneType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\JP_TransferDestination
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JP_ZoneType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JP_ZoneType', is_array($type) ? implode(', ', $type) : var_export($type, true), implode(', ', \EnumType\JP_ZoneType::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get MeetingPointInfo value
     * @return \StructType\JP_MeetingPointInfo|null
     */
    public function getMeetingPointInfo()
    {
        return $this->MeetingPointInfo;
    }
    /**
     * Set MeetingPointInfo value
     * @param \StructType\JP_MeetingPointInfo $meetingPointInfo
     * @return \StructType\JP_TransferDestination
     */
    public function setMeetingPointInfo(\StructType\JP_MeetingPointInfo $meetingPointInfo = null)
    {
        $this->MeetingPointInfo = $meetingPointInfo;
        return $this;
    }
    /**
     * Get FlightInfo value
     * @return \StructType\JP_FlightInfo|null
     */
    public function getFlightInfo()
    {
        return $this->FlightInfo;
    }
    /**
     * Set FlightInfo value
     * @param \StructType\JP_FlightInfo $flightInfo
     * @return \StructType\JP_TransferDestination
     */
    public function setFlightInfo(\StructType\JP_FlightInfo $flightInfo = null)
    {
        $this->FlightInfo = $flightInfo;
        return $this;
    }
    /**
     * Get ShipInfo value
     * @return \StructType\JP_ShipInfo|null
     */
    public function getShipInfo()
    {
        return $this->ShipInfo;
    }
    /**
     * Set ShipInfo value
     * @param \StructType\JP_ShipInfo $shipInfo
     * @return \StructType\JP_TransferDestination
     */
    public function setShipInfo(\StructType\JP_ShipInfo $shipInfo = null)
    {
        $this->ShipInfo = $shipInfo;
        return $this;
    }
    /**
     * Get TrainInfo value
     * @return \StructType\JP_TrainInfo|null
     */
    public function getTrainInfo()
    {
        return $this->TrainInfo;
    }
    /**
     * Set TrainInfo value
     * @param \StructType\JP_TrainInfo $trainInfo
     * @return \StructType\JP_TransferDestination
     */
    public function setTrainInfo(\StructType\JP_TrainInfo $trainInfo = null)
    {
        $this->TrainInfo = $trainInfo;
        return $this;
    }
    /**
     * Get TerminalDeparture value
     * @return string|null
     */
    public function getTerminalDeparture()
    {
        return $this->TerminalDeparture;
    }
    /**
     * Set TerminalDeparture value
     * @param string $terminalDeparture
     * @return \StructType\JP_TransferDestination
     */
    public function setTerminalDeparture($terminalDeparture = null)
    {
        // validation for constraint: string
        if (!is_null($terminalDeparture) && !is_string($terminalDeparture)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($terminalDeparture, true), gettype($terminalDeparture)), __LINE__);
        }
        $this->TerminalDeparture = $terminalDeparture;
        return $this;
    }
    /**
     * Get TerminalArrival value
     * @return string|null
     */
    public function getTerminalArrival()
    {
        return $this->TerminalArrival;
    }
    /**
     * Set TerminalArrival value
     * @param string $terminalArrival
     * @return \StructType\JP_TransferDestination
     */
    public function setTerminalArrival($terminalArrival = null)
    {
        // validation for constraint: string
        if (!is_null($terminalArrival) && !is_string($terminalArrival)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($terminalArrival, true), gettype($terminalArrival)), __LINE__);
        }
        $this->TerminalArrival = $terminalArrival;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\JP_TransferDestination
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Start value
     * @return string|null
     */
    public function getStart()
    {
        return $this->Start;
    }
    /**
     * Set Start value
     * @param string $start
     * @return \StructType\JP_TransferDestination
     */
    public function setStart($start = null)
    {
        // validation for constraint: string
        if (!is_null($start) && !is_string($start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($start, true), gettype($start)), __LINE__);
        }
        $this->Start = $start;
        return $this;
    }
    /**
     * Get MeetingTime value
     * @return string|null
     */
    public function getMeetingTime()
    {
        return $this->MeetingTime;
    }
    /**
     * Set MeetingTime value
     * @param string $meetingTime
     * @return \StructType\JP_TransferDestination
     */
    public function setMeetingTime($meetingTime = null)
    {
        // validation for constraint: string
        if (!is_null($meetingTime) && !is_string($meetingTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($meetingTime, true), gettype($meetingTime)), __LINE__);
        }
        $this->MeetingTime = $meetingTime;
        return $this;
    }
    /**
     * Get HotelCode value
     * @return string|null
     */
    public function getHotelCode()
    {
        return $this->HotelCode;
    }
    /**
     * Set HotelCode value
     * @param string $hotelCode
     * @return \StructType\JP_TransferDestination
     */
    public function setHotelCode($hotelCode = null)
    {
        // validation for constraint: string
        if (!is_null($hotelCode) && !is_string($hotelCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hotelCode, true), gettype($hotelCode)), __LINE__);
        }
        $this->HotelCode = $hotelCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_TransferDestination
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
