<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_ServiceSimpleInfo StructType
 * @subpackage Structs
 */
class JP_ServiceSimpleInfo extends AbstractStructBase
{
    /**
     * The IntCode
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $IntCode;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Options
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_ServiceOption
     */
    public $Options;
    /**
     * The Zones
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_Zone
     */
    public $Zones;
    /**
     * The Origins
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_Origin
     */
    public $Origins;
    /**
     * The Destinations
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_Destination
     */
    public $Destinations;
    /**
     * The ServiceType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_ServiceType
     */
    public $ServiceType;
    /**
     * The Contracts
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_ServiceContract
     */
    public $Contracts;
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * The ProductGroup
     * @var int
     */
    public $ProductGroup;
    /**
     * The ProductType
     * @var string
     */
    public $ProductType;
    /**
     * The ProductTypeBreakdown
     * @var string
     */
    public $ProductTypeBreakdown;
    /**
     * Constructor method for JP_ServiceSimpleInfo
     * @uses JP_ServiceSimpleInfo::setIntCode()
     * @uses JP_ServiceSimpleInfo::setName()
     * @uses JP_ServiceSimpleInfo::setOptions()
     * @uses JP_ServiceSimpleInfo::setZones()
     * @uses JP_ServiceSimpleInfo::setOrigins()
     * @uses JP_ServiceSimpleInfo::setDestinations()
     * @uses JP_ServiceSimpleInfo::setServiceType()
     * @uses JP_ServiceSimpleInfo::setContracts()
     * @uses JP_ServiceSimpleInfo::setCode()
     * @uses JP_ServiceSimpleInfo::setProductGroup()
     * @uses JP_ServiceSimpleInfo::setProductType()
     * @uses JP_ServiceSimpleInfo::setProductTypeBreakdown()
     * @param int $intCode
     * @param string $name
     * @param \ArrayType\ArrayOfJP_ServiceOption $options
     * @param \ArrayType\ArrayOfJP_Zone $zones
     * @param \ArrayType\ArrayOfJP_Origin $origins
     * @param \ArrayType\ArrayOfJP_Destination $destinations
     * @param \StructType\JP_ServiceType $serviceType
     * @param \ArrayType\ArrayOfJP_ServiceContract $contracts
     * @param string $code
     * @param int $productGroup
     * @param string $productType
     * @param string $productTypeBreakdown
     */
    public function __construct($intCode = null, $name = null, \ArrayType\ArrayOfJP_ServiceOption $options = null, \ArrayType\ArrayOfJP_Zone $zones = null, \ArrayType\ArrayOfJP_Origin $origins = null, \ArrayType\ArrayOfJP_Destination $destinations = null, \StructType\JP_ServiceType $serviceType = null, \ArrayType\ArrayOfJP_ServiceContract $contracts = null, $code = null, $productGroup = null, $productType = null, $productTypeBreakdown = null)
    {
        $this
            ->setIntCode($intCode)
            ->setName($name)
            ->setOptions($options)
            ->setZones($zones)
            ->setOrigins($origins)
            ->setDestinations($destinations)
            ->setServiceType($serviceType)
            ->setContracts($contracts)
            ->setCode($code)
            ->setProductGroup($productGroup)
            ->setProductType($productType)
            ->setProductTypeBreakdown($productTypeBreakdown);
    }
    /**
     * Get IntCode value
     * @return int
     */
    public function getIntCode()
    {
        return $this->IntCode;
    }
    /**
     * Set IntCode value
     * @param int $intCode
     * @return \StructType\JP_ServiceSimpleInfo
     */
    public function setIntCode($intCode = null)
    {
        // validation for constraint: int
        if (!is_null($intCode) && !(is_int($intCode) || ctype_digit($intCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($intCode, true), gettype($intCode)), __LINE__);
        }
        $this->IntCode = $intCode;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\JP_ServiceSimpleInfo
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Options value
     * @return \ArrayType\ArrayOfJP_ServiceOption|null
     */
    public function getOptions()
    {
        return $this->Options;
    }
    /**
     * Set Options value
     * @param \ArrayType\ArrayOfJP_ServiceOption $options
     * @return \StructType\JP_ServiceSimpleInfo
     */
    public function setOptions(\ArrayType\ArrayOfJP_ServiceOption $options = null)
    {
        $this->Options = $options;
        return $this;
    }
    /**
     * Get Zones value
     * @return \ArrayType\ArrayOfJP_Zone|null
     */
    public function getZones()
    {
        return $this->Zones;
    }
    /**
     * Set Zones value
     * @param \ArrayType\ArrayOfJP_Zone $zones
     * @return \StructType\JP_ServiceSimpleInfo
     */
    public function setZones(\ArrayType\ArrayOfJP_Zone $zones = null)
    {
        $this->Zones = $zones;
        return $this;
    }
    /**
     * Get Origins value
     * @return \ArrayType\ArrayOfJP_Origin|null
     */
    public function getOrigins()
    {
        return $this->Origins;
    }
    /**
     * Set Origins value
     * @param \ArrayType\ArrayOfJP_Origin $origins
     * @return \StructType\JP_ServiceSimpleInfo
     */
    public function setOrigins(\ArrayType\ArrayOfJP_Origin $origins = null)
    {
        $this->Origins = $origins;
        return $this;
    }
    /**
     * Get Destinations value
     * @return \ArrayType\ArrayOfJP_Destination|null
     */
    public function getDestinations()
    {
        return $this->Destinations;
    }
    /**
     * Set Destinations value
     * @param \ArrayType\ArrayOfJP_Destination $destinations
     * @return \StructType\JP_ServiceSimpleInfo
     */
    public function setDestinations(\ArrayType\ArrayOfJP_Destination $destinations = null)
    {
        $this->Destinations = $destinations;
        return $this;
    }
    /**
     * Get ServiceType value
     * @return \StructType\JP_ServiceType|null
     */
    public function getServiceType()
    {
        return $this->ServiceType;
    }
    /**
     * Set ServiceType value
     * @param \StructType\JP_ServiceType $serviceType
     * @return \StructType\JP_ServiceSimpleInfo
     */
    public function setServiceType(\StructType\JP_ServiceType $serviceType = null)
    {
        $this->ServiceType = $serviceType;
        return $this;
    }
    /**
     * Get Contracts value
     * @return \ArrayType\ArrayOfJP_ServiceContract|null
     */
    public function getContracts()
    {
        return $this->Contracts;
    }
    /**
     * Set Contracts value
     * @param \ArrayType\ArrayOfJP_ServiceContract $contracts
     * @return \StructType\JP_ServiceSimpleInfo
     */
    public function setContracts(\ArrayType\ArrayOfJP_ServiceContract $contracts = null)
    {
        $this->Contracts = $contracts;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\JP_ServiceSimpleInfo
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get ProductGroup value
     * @return int|null
     */
    public function getProductGroup()
    {
        return $this->ProductGroup;
    }
    /**
     * Set ProductGroup value
     * @param int $productGroup
     * @return \StructType\JP_ServiceSimpleInfo
     */
    public function setProductGroup($productGroup = null)
    {
        // validation for constraint: int
        if (!is_null($productGroup) && !(is_int($productGroup) || ctype_digit($productGroup))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($productGroup, true), gettype($productGroup)), __LINE__);
        }
        $this->ProductGroup = $productGroup;
        return $this;
    }
    /**
     * Get ProductType value
     * @return string|null
     */
    public function getProductType()
    {
        return $this->ProductType;
    }
    /**
     * Set ProductType value
     * @param string $productType
     * @return \StructType\JP_ServiceSimpleInfo
     */
    public function setProductType($productType = null)
    {
        // validation for constraint: string
        if (!is_null($productType) && !is_string($productType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productType, true), gettype($productType)), __LINE__);
        }
        $this->ProductType = $productType;
        return $this;
    }
    /**
     * Get ProductTypeBreakdown value
     * @return string|null
     */
    public function getProductTypeBreakdown()
    {
        return $this->ProductTypeBreakdown;
    }
    /**
     * Set ProductTypeBreakdown value
     * @param string $productTypeBreakdown
     * @return \StructType\JP_ServiceSimpleInfo
     */
    public function setProductTypeBreakdown($productTypeBreakdown = null)
    {
        // validation for constraint: string
        if (!is_null($productTypeBreakdown) && !is_string($productTypeBreakdown)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productTypeBreakdown, true), gettype($productTypeBreakdown)), __LINE__);
        }
        $this->ProductTypeBreakdown = $productTypeBreakdown;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_ServiceSimpleInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
