<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_Routes StructType
 * @subpackage Structs
 */
class JP_Routes extends AbstractStructBase
{
    /**
     * The Route
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_Route[]
     */
    public $Route;
    /**
     * The ValidatingCarrier
     * @var string
     */
    public $ValidatingCarrier;
    /**
     * Constructor method for JP_Routes
     * @uses JP_Routes::setRoute()
     * @uses JP_Routes::setValidatingCarrier()
     * @param \StructType\JP_Route[] $route
     * @param string $validatingCarrier
     */
    public function __construct(array $route = array(), $validatingCarrier = null)
    {
        $this
            ->setRoute($route)
            ->setValidatingCarrier($validatingCarrier);
    }
    /**
     * Get Route value
     * @return \StructType\JP_Route[]|null
     */
    public function getRoute()
    {
        return $this->Route;
    }
    /**
     * This method is responsible for validating the values passed to the setRoute method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRoute method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRouteForArrayConstraintsFromSetRoute(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $jP_RoutesRouteItem) {
            // validation for constraint: itemType
            if (!$jP_RoutesRouteItem instanceof \StructType\JP_Route) {
                $invalidValues[] = is_object($jP_RoutesRouteItem) ? get_class($jP_RoutesRouteItem) : sprintf('%s(%s)', gettype($jP_RoutesRouteItem), var_export($jP_RoutesRouteItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Route property can only contain items of type \StructType\JP_Route, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Route value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_Route[] $route
     * @return \StructType\JP_Routes
     */
    public function setRoute(array $route = array())
    {
        // validation for constraint: array
        if ('' !== ($routeArrayErrorMessage = self::validateRouteForArrayConstraintsFromSetRoute($route))) {
            throw new \InvalidArgumentException($routeArrayErrorMessage, __LINE__);
        }
        $this->Route = $route;
        return $this;
    }
    /**
     * Add item to Route value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_Route $item
     * @return \StructType\JP_Routes
     */
    public function addToRoute(\StructType\JP_Route $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_Route) {
            throw new \InvalidArgumentException(sprintf('The Route property can only contain items of type \StructType\JP_Route, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Route[] = $item;
        return $this;
    }
    /**
     * Get ValidatingCarrier value
     * @return string|null
     */
    public function getValidatingCarrier()
    {
        return $this->ValidatingCarrier;
    }
    /**
     * Set ValidatingCarrier value
     * @param string $validatingCarrier
     * @return \StructType\JP_Routes
     */
    public function setValidatingCarrier($validatingCarrier = null)
    {
        // validation for constraint: string
        if (!is_null($validatingCarrier) && !is_string($validatingCarrier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($validatingCarrier, true), gettype($validatingCarrier)), __LINE__);
        }
        $this->ValidatingCarrier = $validatingCarrier;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_Routes
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
