<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_RentacarResult StructType
 * @subpackage Structs
 */
class JP_RentacarResult extends AbstractStructBase
{
    /**
     * The RentacarInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_RentacarInfo
     */
    public $RentacarInfo;
    /**
     * The OriginZoneName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var mixed
     */
    public $OriginZoneName;
    /**
     * The DestinationZoneName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var mixed
     */
    public $DestinationZoneName;
    /**
     * The ExternalProduct
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $ExternalProduct;
    /**
     * The Order
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Order;
    /**
     * The RentacarOptions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_RentacarOption
     */
    public $RentacarOptions;
    /**
     * The RentacarLocationDetails
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_RentacarLocationDetail
     */
    public $RentacarLocationDetails;
    /**
     * The Supplier
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_Supplier
     */
    public $Supplier;
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * The OriginZone
     * @var string
     */
    public $OriginZone;
    /**
     * The DestinationZone
     * @var string
     */
    public $DestinationZone;
    /**
     * Constructor method for JP_RentacarResult
     * @uses JP_RentacarResult::setRentacarInfo()
     * @uses JP_RentacarResult::setOriginZoneName()
     * @uses JP_RentacarResult::setDestinationZoneName()
     * @uses JP_RentacarResult::setExternalProduct()
     * @uses JP_RentacarResult::setOrder()
     * @uses JP_RentacarResult::setRentacarOptions()
     * @uses JP_RentacarResult::setRentacarLocationDetails()
     * @uses JP_RentacarResult::setSupplier()
     * @uses JP_RentacarResult::setCode()
     * @uses JP_RentacarResult::setOriginZone()
     * @uses JP_RentacarResult::setDestinationZone()
     * @param \StructType\JP_RentacarInfo $rentacarInfo
     * @param mixed $originZoneName
     * @param mixed $destinationZoneName
     * @param bool $externalProduct
     * @param int $order
     * @param \ArrayType\ArrayOfJP_RentacarOption $rentacarOptions
     * @param \ArrayType\ArrayOfJP_RentacarLocationDetail $rentacarLocationDetails
     * @param \StructType\JP_Supplier $supplier
     * @param string $code
     * @param string $originZone
     * @param string $destinationZone
     */
    public function __construct(\StructType\JP_RentacarInfo $rentacarInfo = null, $originZoneName = null, $destinationZoneName = null, $externalProduct = null, $order = null, \ArrayType\ArrayOfJP_RentacarOption $rentacarOptions = null, \ArrayType\ArrayOfJP_RentacarLocationDetail $rentacarLocationDetails = null, \StructType\JP_Supplier $supplier = null, $code = null, $originZone = null, $destinationZone = null)
    {
        $this
            ->setRentacarInfo($rentacarInfo)
            ->setOriginZoneName($originZoneName)
            ->setDestinationZoneName($destinationZoneName)
            ->setExternalProduct($externalProduct)
            ->setOrder($order)
            ->setRentacarOptions($rentacarOptions)
            ->setRentacarLocationDetails($rentacarLocationDetails)
            ->setSupplier($supplier)
            ->setCode($code)
            ->setOriginZone($originZone)
            ->setDestinationZone($destinationZone);
    }
    /**
     * Get RentacarInfo value
     * @return \StructType\JP_RentacarInfo|null
     */
    public function getRentacarInfo()
    {
        return $this->RentacarInfo;
    }
    /**
     * Set RentacarInfo value
     * @param \StructType\JP_RentacarInfo $rentacarInfo
     * @return \StructType\JP_RentacarResult
     */
    public function setRentacarInfo(\StructType\JP_RentacarInfo $rentacarInfo = null)
    {
        $this->RentacarInfo = $rentacarInfo;
        return $this;
    }
    /**
     * Get OriginZoneName value
     * @return mixed|null
     */
    public function getOriginZoneName()
    {
        return $this->OriginZoneName;
    }
    /**
     * Set OriginZoneName value
     * @param mixed $originZoneName
     * @return \StructType\JP_RentacarResult
     */
    public function setOriginZoneName($originZoneName = null)
    {
        $this->OriginZoneName = $originZoneName;
        return $this;
    }
    /**
     * Get DestinationZoneName value
     * @return mixed|null
     */
    public function getDestinationZoneName()
    {
        return $this->DestinationZoneName;
    }
    /**
     * Set DestinationZoneName value
     * @param mixed $destinationZoneName
     * @return \StructType\JP_RentacarResult
     */
    public function setDestinationZoneName($destinationZoneName = null)
    {
        $this->DestinationZoneName = $destinationZoneName;
        return $this;
    }
    /**
     * Get ExternalProduct value
     * @return bool|null
     */
    public function getExternalProduct()
    {
        return $this->ExternalProduct;
    }
    /**
     * Set ExternalProduct value
     * @param bool $externalProduct
     * @return \StructType\JP_RentacarResult
     */
    public function setExternalProduct($externalProduct = null)
    {
        // validation for constraint: boolean
        if (!is_null($externalProduct) && !is_bool($externalProduct)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($externalProduct, true), gettype($externalProduct)), __LINE__);
        }
        $this->ExternalProduct = $externalProduct;
        return $this;
    }
    /**
     * Get Order value
     * @return int|null
     */
    public function getOrder()
    {
        return $this->Order;
    }
    /**
     * Set Order value
     * @param int $order
     * @return \StructType\JP_RentacarResult
     */
    public function setOrder($order = null)
    {
        // validation for constraint: int
        if (!is_null($order) && !(is_int($order) || ctype_digit($order))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($order, true), gettype($order)), __LINE__);
        }
        $this->Order = $order;
        return $this;
    }
    /**
     * Get RentacarOptions value
     * @return \ArrayType\ArrayOfJP_RentacarOption|null
     */
    public function getRentacarOptions()
    {
        return $this->RentacarOptions;
    }
    /**
     * Set RentacarOptions value
     * @param \ArrayType\ArrayOfJP_RentacarOption $rentacarOptions
     * @return \StructType\JP_RentacarResult
     */
    public function setRentacarOptions(\ArrayType\ArrayOfJP_RentacarOption $rentacarOptions = null)
    {
        $this->RentacarOptions = $rentacarOptions;
        return $this;
    }
    /**
     * Get RentacarLocationDetails value
     * @return \ArrayType\ArrayOfJP_RentacarLocationDetail|null
     */
    public function getRentacarLocationDetails()
    {
        return $this->RentacarLocationDetails;
    }
    /**
     * Set RentacarLocationDetails value
     * @param \ArrayType\ArrayOfJP_RentacarLocationDetail $rentacarLocationDetails
     * @return \StructType\JP_RentacarResult
     */
    public function setRentacarLocationDetails(\ArrayType\ArrayOfJP_RentacarLocationDetail $rentacarLocationDetails = null)
    {
        $this->RentacarLocationDetails = $rentacarLocationDetails;
        return $this;
    }
    /**
     * Get Supplier value
     * @return \StructType\JP_Supplier|null
     */
    public function getSupplier()
    {
        return $this->Supplier;
    }
    /**
     * Set Supplier value
     * @param \StructType\JP_Supplier $supplier
     * @return \StructType\JP_RentacarResult
     */
    public function setSupplier(\StructType\JP_Supplier $supplier = null)
    {
        $this->Supplier = $supplier;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\JP_RentacarResult
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get OriginZone value
     * @return string|null
     */
    public function getOriginZone()
    {
        return $this->OriginZone;
    }
    /**
     * Set OriginZone value
     * @param string $originZone
     * @return \StructType\JP_RentacarResult
     */
    public function setOriginZone($originZone = null)
    {
        // validation for constraint: string
        if (!is_null($originZone) && !is_string($originZone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originZone, true), gettype($originZone)), __LINE__);
        }
        $this->OriginZone = $originZone;
        return $this;
    }
    /**
     * Get DestinationZone value
     * @return string|null
     */
    public function getDestinationZone()
    {
        return $this->DestinationZone;
    }
    /**
     * Set DestinationZone value
     * @param string $destinationZone
     * @return \StructType\JP_RentacarResult
     */
    public function setDestinationZone($destinationZone = null)
    {
        // validation for constraint: string
        if (!is_null($destinationZone) && !is_string($destinationZone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destinationZone, true), gettype($destinationZone)), __LINE__);
        }
        $this->DestinationZone = $destinationZone;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_RentacarResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
