<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_HotelPortfolio StructType
 * @subpackage Structs
 */
class JP_HotelPortfolio extends AbstractStructBase
{
    /**
     * The Hotel
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_ExtendedHotelInfo[]
     */
    public $Hotel;
    /**
     * The Page
     * @var int
     */
    public $Page;
    /**
     * The RecordsPerPage
     * @var int
     */
    public $RecordsPerPage;
    /**
     * The TotalPages
     * @var int
     */
    public $TotalPages;
    /**
     * The TotalRecords
     * @var int
     */
    public $TotalRecords;
    /**
     * The NextToken
     * @var string
     */
    public $NextToken;
    /**
     * Constructor method for JP_HotelPortfolio
     * @uses JP_HotelPortfolio::setHotel()
     * @uses JP_HotelPortfolio::setPage()
     * @uses JP_HotelPortfolio::setRecordsPerPage()
     * @uses JP_HotelPortfolio::setTotalPages()
     * @uses JP_HotelPortfolio::setTotalRecords()
     * @uses JP_HotelPortfolio::setNextToken()
     * @param \StructType\JP_ExtendedHotelInfo[] $hotel
     * @param int $page
     * @param int $recordsPerPage
     * @param int $totalPages
     * @param int $totalRecords
     * @param string $nextToken
     */
    public function __construct(array $hotel = array(), $page = null, $recordsPerPage = null, $totalPages = null, $totalRecords = null, $nextToken = null)
    {
        $this
            ->setHotel($hotel)
            ->setPage($page)
            ->setRecordsPerPage($recordsPerPage)
            ->setTotalPages($totalPages)
            ->setTotalRecords($totalRecords)
            ->setNextToken($nextToken);
    }
    /**
     * Get Hotel value
     * @return \StructType\JP_ExtendedHotelInfo[]|null
     */
    public function getHotel()
    {
        return $this->Hotel;
    }
    /**
     * This method is responsible for validating the values passed to the setHotel method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHotel method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateHotelForArrayConstraintsFromSetHotel(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $jP_HotelPortfolioHotelItem) {
            // validation for constraint: itemType
            if (!$jP_HotelPortfolioHotelItem instanceof \StructType\JP_ExtendedHotelInfo) {
                $invalidValues[] = is_object($jP_HotelPortfolioHotelItem) ? get_class($jP_HotelPortfolioHotelItem) : sprintf('%s(%s)', gettype($jP_HotelPortfolioHotelItem), var_export($jP_HotelPortfolioHotelItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Hotel property can only contain items of type \StructType\JP_ExtendedHotelInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Hotel value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_ExtendedHotelInfo[] $hotel
     * @return \StructType\JP_HotelPortfolio
     */
    public function setHotel(array $hotel = array())
    {
        // validation for constraint: array
        if ('' !== ($hotelArrayErrorMessage = self::validateHotelForArrayConstraintsFromSetHotel($hotel))) {
            throw new \InvalidArgumentException($hotelArrayErrorMessage, __LINE__);
        }
        $this->Hotel = $hotel;
        return $this;
    }
    /**
     * Add item to Hotel value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_ExtendedHotelInfo $item
     * @return \StructType\JP_HotelPortfolio
     */
    public function addToHotel(\StructType\JP_ExtendedHotelInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_ExtendedHotelInfo) {
            throw new \InvalidArgumentException(sprintf('The Hotel property can only contain items of type \StructType\JP_ExtendedHotelInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Hotel[] = $item;
        return $this;
    }
    /**
     * Get Page value
     * @return int|null
     */
    public function getPage()
    {
        return $this->Page;
    }
    /**
     * Set Page value
     * @param int $page
     * @return \StructType\JP_HotelPortfolio
     */
    public function setPage($page = null)
    {
        // validation for constraint: int
        if (!is_null($page) && !(is_int($page) || ctype_digit($page))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($page, true), gettype($page)), __LINE__);
        }
        $this->Page = $page;
        return $this;
    }
    /**
     * Get RecordsPerPage value
     * @return int|null
     */
    public function getRecordsPerPage()
    {
        return $this->RecordsPerPage;
    }
    /**
     * Set RecordsPerPage value
     * @param int $recordsPerPage
     * @return \StructType\JP_HotelPortfolio
     */
    public function setRecordsPerPage($recordsPerPage = null)
    {
        // validation for constraint: int
        if (!is_null($recordsPerPage) && !(is_int($recordsPerPage) || ctype_digit($recordsPerPage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($recordsPerPage, true), gettype($recordsPerPage)), __LINE__);
        }
        $this->RecordsPerPage = $recordsPerPage;
        return $this;
    }
    /**
     * Get TotalPages value
     * @return int|null
     */
    public function getTotalPages()
    {
        return $this->TotalPages;
    }
    /**
     * Set TotalPages value
     * @param int $totalPages
     * @return \StructType\JP_HotelPortfolio
     */
    public function setTotalPages($totalPages = null)
    {
        // validation for constraint: int
        if (!is_null($totalPages) && !(is_int($totalPages) || ctype_digit($totalPages))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalPages, true), gettype($totalPages)), __LINE__);
        }
        $this->TotalPages = $totalPages;
        return $this;
    }
    /**
     * Get TotalRecords value
     * @return int|null
     */
    public function getTotalRecords()
    {
        return $this->TotalRecords;
    }
    /**
     * Set TotalRecords value
     * @param int $totalRecords
     * @return \StructType\JP_HotelPortfolio
     */
    public function setTotalRecords($totalRecords = null)
    {
        // validation for constraint: int
        if (!is_null($totalRecords) && !(is_int($totalRecords) || ctype_digit($totalRecords))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalRecords, true), gettype($totalRecords)), __LINE__);
        }
        $this->TotalRecords = $totalRecords;
        return $this;
    }
    /**
     * Get NextToken value
     * @return string|null
     */
    public function getNextToken()
    {
        return $this->NextToken;
    }
    /**
     * Set NextToken value
     * @param string $nextToken
     * @return \StructType\JP_HotelPortfolio
     */
    public function setNextToken($nextToken = null)
    {
        // validation for constraint: string
        if (!is_null($nextToken) && !is_string($nextToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nextToken, true), gettype($nextToken)), __LINE__);
        }
        $this->NextToken = $nextToken;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_HotelPortfolio
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
