<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_ConceptBreakdown StructType
 * @subpackage Structs
 */
class JP_ConceptBreakdown extends AbstractStructBase
{
    /**
     * The Items
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_ItemBreakdown
     */
    public $Items;
    /**
     * The Taxes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_CommonPriceBreakdown
     */
    public $Taxes;
    /**
     * The Type
     * @var string
     */
    public $Type;
    /**
     * The Name
     * @var string
     */
    public $Name;
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * The RelationalCode
     * @var string
     */
    public $RelationalCode;
    /**
     * Constructor method for JP_ConceptBreakdown
     * @uses JP_ConceptBreakdown::setItems()
     * @uses JP_ConceptBreakdown::setTaxes()
     * @uses JP_ConceptBreakdown::setType()
     * @uses JP_ConceptBreakdown::setName()
     * @uses JP_ConceptBreakdown::setCode()
     * @uses JP_ConceptBreakdown::setRelationalCode()
     * @param \ArrayType\ArrayOfJP_ItemBreakdown $items
     * @param \ArrayType\ArrayOfJP_CommonPriceBreakdown $taxes
     * @param string $type
     * @param string $name
     * @param string $code
     * @param string $relationalCode
     */
    public function __construct(\ArrayType\ArrayOfJP_ItemBreakdown $items = null, \ArrayType\ArrayOfJP_CommonPriceBreakdown $taxes = null, $type = null, $name = null, $code = null, $relationalCode = null)
    {
        $this
            ->setItems($items)
            ->setTaxes($taxes)
            ->setType($type)
            ->setName($name)
            ->setCode($code)
            ->setRelationalCode($relationalCode);
    }
    /**
     * Get Items value
     * @return \ArrayType\ArrayOfJP_ItemBreakdown|null
     */
    public function getItems()
    {
        return $this->Items;
    }
    /**
     * Set Items value
     * @param \ArrayType\ArrayOfJP_ItemBreakdown $items
     * @return \StructType\JP_ConceptBreakdown
     */
    public function setItems(\ArrayType\ArrayOfJP_ItemBreakdown $items = null)
    {
        $this->Items = $items;
        return $this;
    }
    /**
     * Get Taxes value
     * @return \ArrayType\ArrayOfJP_CommonPriceBreakdown|null
     */
    public function getTaxes()
    {
        return $this->Taxes;
    }
    /**
     * Set Taxes value
     * @param \ArrayType\ArrayOfJP_CommonPriceBreakdown $taxes
     * @return \StructType\JP_ConceptBreakdown
     */
    public function setTaxes(\ArrayType\ArrayOfJP_CommonPriceBreakdown $taxes = null)
    {
        $this->Taxes = $taxes;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \StructType\JP_ConceptBreakdown
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\JP_ConceptBreakdown
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\JP_ConceptBreakdown
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get RelationalCode value
     * @return string|null
     */
    public function getRelationalCode()
    {
        return $this->RelationalCode;
    }
    /**
     * Set RelationalCode value
     * @param string $relationalCode
     * @return \StructType\JP_ConceptBreakdown
     */
    public function setRelationalCode($relationalCode = null)
    {
        // validation for constraint: string
        if (!is_null($relationalCode) && !is_string($relationalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relationalCode, true), gettype($relationalCode)), __LINE__);
        }
        $this->RelationalCode = $relationalCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_ConceptBreakdown
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
