<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_CancelInformation StructType
 * @subpackage Structs
 */
class JP_CancelInformation extends AbstractStructBase
{
    /**
     * The BookingCodeState
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BookingCodeState;
    /**
     * The BookingCancelCost
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $BookingCancelCost;
    /**
     * The BookingCancelCostCurrency
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BookingCancelCostCurrency;
    /**
     * Constructor method for JP_CancelInformation
     * @uses JP_CancelInformation::setBookingCodeState()
     * @uses JP_CancelInformation::setBookingCancelCost()
     * @uses JP_CancelInformation::setBookingCancelCostCurrency()
     * @param string $bookingCodeState
     * @param float $bookingCancelCost
     * @param string $bookingCancelCostCurrency
     */
    public function __construct($bookingCodeState = null, $bookingCancelCost = null, $bookingCancelCostCurrency = null)
    {
        $this
            ->setBookingCodeState($bookingCodeState)
            ->setBookingCancelCost($bookingCancelCost)
            ->setBookingCancelCostCurrency($bookingCancelCostCurrency);
    }
    /**
     * Get BookingCodeState value
     * @return string|null
     */
    public function getBookingCodeState()
    {
        return $this->BookingCodeState;
    }
    /**
     * Set BookingCodeState value
     * @param string $bookingCodeState
     * @return \StructType\JP_CancelInformation
     */
    public function setBookingCodeState($bookingCodeState = null)
    {
        // validation for constraint: string
        if (!is_null($bookingCodeState) && !is_string($bookingCodeState)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bookingCodeState, true), gettype($bookingCodeState)), __LINE__);
        }
        $this->BookingCodeState = $bookingCodeState;
        return $this;
    }
    /**
     * Get BookingCancelCost value
     * @return float|null
     */
    public function getBookingCancelCost()
    {
        return $this->BookingCancelCost;
    }
    /**
     * Set BookingCancelCost value
     * @param float $bookingCancelCost
     * @return \StructType\JP_CancelInformation
     */
    public function setBookingCancelCost($bookingCancelCost = null)
    {
        // validation for constraint: float
        if (!is_null($bookingCancelCost) && !(is_float($bookingCancelCost) || is_numeric($bookingCancelCost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($bookingCancelCost, true), gettype($bookingCancelCost)), __LINE__);
        }
        $this->BookingCancelCost = $bookingCancelCost;
        return $this;
    }
    /**
     * Get BookingCancelCostCurrency value
     * @return string|null
     */
    public function getBookingCancelCostCurrency()
    {
        return $this->BookingCancelCostCurrency;
    }
    /**
     * Set BookingCancelCostCurrency value
     * @param string $bookingCancelCostCurrency
     * @return \StructType\JP_CancelInformation
     */
    public function setBookingCancelCostCurrency($bookingCancelCostCurrency = null)
    {
        // validation for constraint: string
        if (!is_null($bookingCancelCostCurrency) && !is_string($bookingCancelCostCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bookingCancelCostCurrency, true), gettype($bookingCancelCostCurrency)), __LINE__);
        }
        $this->BookingCancelCostCurrency = $bookingCancelCostCurrency;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_CancelInformation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
