<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Package ServiceType
 * @subpackage Services
 */
class Package extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named PackageBooking
     * Meta informations extracted from the WSDL
     * - documentation: Booking for packages.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PackageBooking $parameters
     * @return \StructType\PackageBookingResponse|bool
     */
    public function PackageBooking(\StructType\PackageBooking $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->PackageBooking($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PackageAvail
     * Meta informations extracted from the WSDL
     * - documentation: Availability for packages.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PackageAvail $parameters
     * @return \StructType\PackageAvailResponse|bool
     */
    public function PackageAvail(\StructType\PackageAvail $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->PackageAvail($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PackageChangeProduct
     * Meta informations extracted from the WSDL
     * - documentation: Change product for packages.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PackageChangeProduct $parameters
     * @return \StructType\PackageChangeProductResponse|bool
     */
    public function PackageChangeProduct(\StructType\PackageChangeProduct $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->PackageChangeProduct($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PackageList
     * Meta informations extracted from the WSDL
     * - documentation: List of Packages
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PackageList $parameters
     * @return \StructType\PackageListResponse|bool
     */
    public function PackageList(\StructType\PackageList $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->PackageList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PackageCalendarPrice
     * Meta informations extracted from the WSDL
     * - documentation: Package calendar price
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PackageCalendarPrice $parameters
     * @return \StructType\PackageCalendarPriceResponse|bool
     */
    public function PackageCalendarPrice(\StructType\PackageCalendarPrice $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->PackageCalendarPrice($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PackageSearcher
     * Meta informations extracted from the WSDL
     * - documentation: Various of Packages
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PackageSearcher $parameters
     * @return \StructType\PackageSearcherResponse|bool
     */
    public function PackageSearcher(\StructType\PackageSearcher $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->PackageSearcher($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PackageContent
     * Meta informations extracted from the WSDL
     * - documentation: Content Of Packages
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PackageContent $parameters
     * @return \StructType\PackageContentResponse|bool
     */
    public function PackageContent(\StructType\PackageContent $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->PackageContent($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PackageCheckAvail
     * Meta informations extracted from the WSDL
     * - documentation: CheckAvail for packages.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PackageCheckAvail $parameters
     * @return \StructType\PackageCheckAvailResponse|bool
     */
    public function PackageCheckAvail(\StructType\PackageCheckAvail $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->PackageCheckAvail($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PackageBookingRules
     * Meta informations extracted from the WSDL
     * - documentation: BookingRules Of Packages
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PackageBookingRules $parameters
     * @return \StructType\PackageBookingRulesResponse|bool
     */
    public function PackageBookingRules(\StructType\PackageBookingRules $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->PackageBookingRules($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\PackageAvailResponse|\StructType\PackageBookingResponse|\StructType\PackageBookingRulesResponse|\StructType\PackageCalendarPriceResponse|\StructType\PackageChangeProductResponse|\StructType\PackageCheckAvailResponse|\StructType\PackageContentResponse|\StructType\PackageListResponse|\StructType\PackageSearcherResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
