<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfJP_HotelElement ArrayType
 * @subpackage Arrays
 */
class ArrayOfJP_HotelElement extends AbstractStructArrayBase
{
    /**
     * The HotelElement
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_HotelElement[]
     */
    public $HotelElement;
    /**
     * Constructor method for ArrayOfJP_HotelElement
     * @uses ArrayOfJP_HotelElement::setHotelElement()
     * @param \StructType\JP_HotelElement[] $hotelElement
     */
    public function __construct(array $hotelElement = array())
    {
        $this
            ->setHotelElement($hotelElement);
    }
    /**
     * Get HotelElement value
     * @return \StructType\JP_HotelElement[]|null
     */
    public function getHotelElement()
    {
        return $this->HotelElement;
    }
    /**
     * This method is responsible for validating the values passed to the setHotelElement method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHotelElement method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateHotelElementForArrayConstraintsFromSetHotelElement(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfJP_HotelElementHotelElementItem) {
            // validation for constraint: itemType
            if (!$arrayOfJP_HotelElementHotelElementItem instanceof \StructType\JP_HotelElement) {
                $invalidValues[] = is_object($arrayOfJP_HotelElementHotelElementItem) ? get_class($arrayOfJP_HotelElementHotelElementItem) : sprintf('%s(%s)', gettype($arrayOfJP_HotelElementHotelElementItem), var_export($arrayOfJP_HotelElementHotelElementItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The HotelElement property can only contain items of type \StructType\JP_HotelElement, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set HotelElement value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_HotelElement[] $hotelElement
     * @return \ArrayType\ArrayOfJP_HotelElement
     */
    public function setHotelElement(array $hotelElement = array())
    {
        // validation for constraint: array
        if ('' !== ($hotelElementArrayErrorMessage = self::validateHotelElementForArrayConstraintsFromSetHotelElement($hotelElement))) {
            throw new \InvalidArgumentException($hotelElementArrayErrorMessage, __LINE__);
        }
        $this->HotelElement = $hotelElement;
        return $this;
    }
    /**
     * Add item to HotelElement value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_HotelElement $item
     * @return \ArrayType\ArrayOfJP_HotelElement
     */
    public function addToHotelElement(\StructType\JP_HotelElement $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_HotelElement) {
            throw new \InvalidArgumentException(sprintf('The HotelElement property can only contain items of type \StructType\JP_HotelElement, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->HotelElement[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\JP_HotelElement|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\JP_HotelElement|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\JP_HotelElement|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\JP_HotelElement|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\JP_HotelElement|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string HotelElement
     */
    public function getAttributeName()
    {
        return 'HotelElement';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfJP_HotelElement
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
