<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_SupplementsInfo StructType
 * @subpackage Structs
 */
class JP_SupplementsInfo extends AbstractStructBase
{
    /**
     * The SupplementInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_SupplementInfo[]
     */
    public $SupplementInfo;
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * Constructor method for JP_SupplementsInfo
     * @uses JP_SupplementsInfo::setSupplementInfo()
     * @uses JP_SupplementsInfo::setCode()
     * @param \StructType\JP_SupplementInfo[] $supplementInfo
     * @param string $code
     */
    public function __construct(array $supplementInfo = array(), $code = null)
    {
        $this
            ->setSupplementInfo($supplementInfo)
            ->setCode($code);
    }
    /**
     * Get SupplementInfo value
     * @return \StructType\JP_SupplementInfo[]|null
     */
    public function getSupplementInfo()
    {
        return $this->SupplementInfo;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplementInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplementInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplementInfoForArrayConstraintsFromSetSupplementInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $jP_SupplementsInfoSupplementInfoItem) {
            // validation for constraint: itemType
            if (!$jP_SupplementsInfoSupplementInfoItem instanceof \StructType\JP_SupplementInfo) {
                $invalidValues[] = is_object($jP_SupplementsInfoSupplementInfoItem) ? get_class($jP_SupplementsInfoSupplementInfoItem) : sprintf('%s(%s)', gettype($jP_SupplementsInfoSupplementInfoItem), var_export($jP_SupplementsInfoSupplementInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SupplementInfo property can only contain items of type \StructType\JP_SupplementInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SupplementInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_SupplementInfo[] $supplementInfo
     * @return \StructType\JP_SupplementsInfo
     */
    public function setSupplementInfo(array $supplementInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($supplementInfoArrayErrorMessage = self::validateSupplementInfoForArrayConstraintsFromSetSupplementInfo($supplementInfo))) {
            throw new \InvalidArgumentException($supplementInfoArrayErrorMessage, __LINE__);
        }
        $this->SupplementInfo = $supplementInfo;
        return $this;
    }
    /**
     * Add item to SupplementInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_SupplementInfo $item
     * @return \StructType\JP_SupplementsInfo
     */
    public function addToSupplementInfo(\StructType\JP_SupplementInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_SupplementInfo) {
            throw new \InvalidArgumentException(sprintf('The SupplementInfo property can only contain items of type \StructType\JP_SupplementInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SupplementInfo[] = $item;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\JP_SupplementsInfo
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_SupplementsInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
