<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_ServiceItem StructType
 * @subpackage Structs
 */
class JP_ServiceItem extends JP_BaseItem
{
    /**
     * The Start
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Start;
    /**
     * The End
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $End;
    /**
     * The ServiceInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_ServiceInfo
     */
    public $ServiceInfo;
    /**
     * The AdditionalElements
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_PackageAdditionalElements
     */
    public $AdditionalElements;
    /**
     * The CancellationPolicy
     * Meta informations extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_CancellationPolicyRules
     */
    public $CancellationPolicy;
    /**
     * The ServiceOptions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_ServiceOption
     */
    public $ServiceOptions;
    /**
     * The RelPaxes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_RelPax
     */
    public $RelPaxes;
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * Constructor method for JP_ServiceItem
     * @uses JP_ServiceItem::setStart()
     * @uses JP_ServiceItem::setEnd()
     * @uses JP_ServiceItem::setServiceInfo()
     * @uses JP_ServiceItem::setAdditionalElements()
     * @uses JP_ServiceItem::setCancellationPolicy()
     * @uses JP_ServiceItem::setServiceOptions()
     * @uses JP_ServiceItem::setRelPaxes()
     * @uses JP_ServiceItem::setCode()
     * @param string $start
     * @param string $end
     * @param \StructType\JP_ServiceInfo $serviceInfo
     * @param \StructType\JP_PackageAdditionalElements $additionalElements
     * @param \StructType\JP_CancellationPolicyRules $cancellationPolicy
     * @param \ArrayType\ArrayOfJP_ServiceOption $serviceOptions
     * @param \ArrayType\ArrayOfJP_RelPax $relPaxes
     * @param string $code
     */
    public function __construct($start = null, $end = null, \StructType\JP_ServiceInfo $serviceInfo = null, \StructType\JP_PackageAdditionalElements $additionalElements = null, \StructType\JP_CancellationPolicyRules $cancellationPolicy = null, \ArrayType\ArrayOfJP_ServiceOption $serviceOptions = null, \ArrayType\ArrayOfJP_RelPax $relPaxes = null, $code = null)
    {
        $this
            ->setStart($start)
            ->setEnd($end)
            ->setServiceInfo($serviceInfo)
            ->setAdditionalElements($additionalElements)
            ->setCancellationPolicy($cancellationPolicy)
            ->setServiceOptions($serviceOptions)
            ->setRelPaxes($relPaxes)
            ->setCode($code);
    }
    /**
     * Get Start value
     * @return string
     */
    public function getStart()
    {
        return $this->Start;
    }
    /**
     * Set Start value
     * @param string $start
     * @return \StructType\JP_ServiceItem
     */
    public function setStart($start = null)
    {
        // validation for constraint: string
        if (!is_null($start) && !is_string($start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($start, true), gettype($start)), __LINE__);
        }
        $this->Start = $start;
        return $this;
    }
    /**
     * Get End value
     * @return string
     */
    public function getEnd()
    {
        return $this->End;
    }
    /**
     * Set End value
     * @param string $end
     * @return \StructType\JP_ServiceItem
     */
    public function setEnd($end = null)
    {
        // validation for constraint: string
        if (!is_null($end) && !is_string($end)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($end, true), gettype($end)), __LINE__);
        }
        $this->End = $end;
        return $this;
    }
    /**
     * Get ServiceInfo value
     * @return \StructType\JP_ServiceInfo|null
     */
    public function getServiceInfo()
    {
        return $this->ServiceInfo;
    }
    /**
     * Set ServiceInfo value
     * @param \StructType\JP_ServiceInfo $serviceInfo
     * @return \StructType\JP_ServiceItem
     */
    public function setServiceInfo(\StructType\JP_ServiceInfo $serviceInfo = null)
    {
        $this->ServiceInfo = $serviceInfo;
        return $this;
    }
    /**
     * Get AdditionalElements value
     * @return \StructType\JP_PackageAdditionalElements|null
     */
    public function getAdditionalElements()
    {
        return $this->AdditionalElements;
    }
    /**
     * Set AdditionalElements value
     * @param \StructType\JP_PackageAdditionalElements $additionalElements
     * @return \StructType\JP_ServiceItem
     */
    public function setAdditionalElements(\StructType\JP_PackageAdditionalElements $additionalElements = null)
    {
        $this->AdditionalElements = $additionalElements;
        return $this;
    }
    /**
     * Get CancellationPolicy value
     * @return \StructType\JP_CancellationPolicyRules|null
     */
    public function getCancellationPolicy()
    {
        return $this->CancellationPolicy;
    }
    /**
     * Set CancellationPolicy value
     * @param \StructType\JP_CancellationPolicyRules $cancellationPolicy
     * @return \StructType\JP_ServiceItem
     */
    public function setCancellationPolicy(\StructType\JP_CancellationPolicyRules $cancellationPolicy = null)
    {
        $this->CancellationPolicy = $cancellationPolicy;
        return $this;
    }
    /**
     * Get ServiceOptions value
     * @return \ArrayType\ArrayOfJP_ServiceOption|null
     */
    public function getServiceOptions()
    {
        return $this->ServiceOptions;
    }
    /**
     * Set ServiceOptions value
     * @param \ArrayType\ArrayOfJP_ServiceOption $serviceOptions
     * @return \StructType\JP_ServiceItem
     */
    public function setServiceOptions(\ArrayType\ArrayOfJP_ServiceOption $serviceOptions = null)
    {
        $this->ServiceOptions = $serviceOptions;
        return $this;
    }
    /**
     * Get RelPaxes value
     * @return \ArrayType\ArrayOfJP_RelPax|null
     */
    public function getRelPaxes()
    {
        return $this->RelPaxes;
    }
    /**
     * Set RelPaxes value
     * @param \ArrayType\ArrayOfJP_RelPax $relPaxes
     * @return \StructType\JP_ServiceItem
     */
    public function setRelPaxes(\ArrayType\ArrayOfJP_RelPax $relPaxes = null)
    {
        $this->RelPaxes = $relPaxes;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\JP_ServiceItem
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_ServiceItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
