<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_FinalCustomerSaveResult StructType
 * @subpackage Structs
 */
class JP_FinalCustomerSaveResult extends AbstractStructBase
{
    /**
     * The Errors
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_ErrorType
     */
    public $Errors;
    /**
     * The Warnings
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_Warnings
     */
    public $Warnings;
    /**
     * The FinalCustomer
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_FinalCustomerData[]
     */
    public $FinalCustomer;
    /**
     * The Url
     * @var string
     */
    public $Url;
    /**
     * The TimeStamp
     * @var string
     */
    public $TimeStamp;
    /**
     * The IntCode
     * @var string
     */
    public $IntCode;
    /**
     * Constructor method for JP_FinalCustomerSaveResult
     * @uses JP_FinalCustomerSaveResult::setErrors()
     * @uses JP_FinalCustomerSaveResult::setWarnings()
     * @uses JP_FinalCustomerSaveResult::setFinalCustomer()
     * @uses JP_FinalCustomerSaveResult::setUrl()
     * @uses JP_FinalCustomerSaveResult::setTimeStamp()
     * @uses JP_FinalCustomerSaveResult::setIntCode()
     * @param \ArrayType\ArrayOfJP_ErrorType $errors
     * @param \StructType\JP_Warnings $warnings
     * @param \StructType\JP_FinalCustomerData[] $finalCustomer
     * @param string $url
     * @param string $timeStamp
     * @param string $intCode
     */
    public function __construct(\ArrayType\ArrayOfJP_ErrorType $errors = null, \StructType\JP_Warnings $warnings = null, array $finalCustomer = array(), $url = null, $timeStamp = null, $intCode = null)
    {
        $this
            ->setErrors($errors)
            ->setWarnings($warnings)
            ->setFinalCustomer($finalCustomer)
            ->setUrl($url)
            ->setTimeStamp($timeStamp)
            ->setIntCode($intCode);
    }
    /**
     * Get Errors value
     * @return \ArrayType\ArrayOfJP_ErrorType|null
     */
    public function getErrors()
    {
        return $this->Errors;
    }
    /**
     * Set Errors value
     * @param \ArrayType\ArrayOfJP_ErrorType $errors
     * @return \StructType\JP_FinalCustomerSaveResult
     */
    public function setErrors(\ArrayType\ArrayOfJP_ErrorType $errors = null)
    {
        $this->Errors = $errors;
        return $this;
    }
    /**
     * Get Warnings value
     * @return \StructType\JP_Warnings|null
     */
    public function getWarnings()
    {
        return $this->Warnings;
    }
    /**
     * Set Warnings value
     * @param \StructType\JP_Warnings $warnings
     * @return \StructType\JP_FinalCustomerSaveResult
     */
    public function setWarnings(\StructType\JP_Warnings $warnings = null)
    {
        $this->Warnings = $warnings;
        return $this;
    }
    /**
     * Get FinalCustomer value
     * @return \StructType\JP_FinalCustomerData[]|null
     */
    public function getFinalCustomer()
    {
        return $this->FinalCustomer;
    }
    /**
     * This method is responsible for validating the values passed to the setFinalCustomer method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFinalCustomer method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFinalCustomerForArrayConstraintsFromSetFinalCustomer(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $jP_FinalCustomerSaveResultFinalCustomerItem) {
            // validation for constraint: itemType
            if (!$jP_FinalCustomerSaveResultFinalCustomerItem instanceof \StructType\JP_FinalCustomerData) {
                $invalidValues[] = is_object($jP_FinalCustomerSaveResultFinalCustomerItem) ? get_class($jP_FinalCustomerSaveResultFinalCustomerItem) : sprintf('%s(%s)', gettype($jP_FinalCustomerSaveResultFinalCustomerItem), var_export($jP_FinalCustomerSaveResultFinalCustomerItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The FinalCustomer property can only contain items of type \StructType\JP_FinalCustomerData, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set FinalCustomer value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_FinalCustomerData[] $finalCustomer
     * @return \StructType\JP_FinalCustomerSaveResult
     */
    public function setFinalCustomer(array $finalCustomer = array())
    {
        // validation for constraint: array
        if ('' !== ($finalCustomerArrayErrorMessage = self::validateFinalCustomerForArrayConstraintsFromSetFinalCustomer($finalCustomer))) {
            throw new \InvalidArgumentException($finalCustomerArrayErrorMessage, __LINE__);
        }
        $this->FinalCustomer = $finalCustomer;
        return $this;
    }
    /**
     * Add item to FinalCustomer value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_FinalCustomerData $item
     * @return \StructType\JP_FinalCustomerSaveResult
     */
    public function addToFinalCustomer(\StructType\JP_FinalCustomerData $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_FinalCustomerData) {
            throw new \InvalidArgumentException(sprintf('The FinalCustomer property can only contain items of type \StructType\JP_FinalCustomerData, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->FinalCustomer[] = $item;
        return $this;
    }
    /**
     * Get Url value
     * @return string|null
     */
    public function getUrl()
    {
        return $this->Url;
    }
    /**
     * Set Url value
     * @param string $url
     * @return \StructType\JP_FinalCustomerSaveResult
     */
    public function setUrl($url = null)
    {
        // validation for constraint: string
        if (!is_null($url) && !is_string($url)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($url, true), gettype($url)), __LINE__);
        }
        $this->Url = $url;
        return $this;
    }
    /**
     * Get TimeStamp value
     * @return string|null
     */
    public function getTimeStamp()
    {
        return $this->TimeStamp;
    }
    /**
     * Set TimeStamp value
     * @param string $timeStamp
     * @return \StructType\JP_FinalCustomerSaveResult
     */
    public function setTimeStamp($timeStamp = null)
    {
        // validation for constraint: string
        if (!is_null($timeStamp) && !is_string($timeStamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timeStamp, true), gettype($timeStamp)), __LINE__);
        }
        $this->TimeStamp = $timeStamp;
        return $this;
    }
    /**
     * Get IntCode value
     * @return string|null
     */
    public function getIntCode()
    {
        return $this->IntCode;
    }
    /**
     * Set IntCode value
     * @param string $intCode
     * @return \StructType\JP_FinalCustomerSaveResult
     */
    public function setIntCode($intCode = null)
    {
        // validation for constraint: string
        if (!is_null($intCode) && !is_string($intCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($intCode, true), gettype($intCode)), __LINE__);
        }
        $this->IntCode = $intCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_FinalCustomerSaveResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
