<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JPSOAP_ApplicationRules StructType
 * @subpackage Structs
 */
class JPSOAP_ApplicationRules extends AbstractStructBase
{
    /**
     * The MustMatchAllStayDates
     * Meta informations extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $MustMatchAllStayDates;
    /**
     * The ApplyAllStayIfMatchAnyDate
     * Meta informations extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $ApplyAllStayIfMatchAnyDate;
    /**
     * The Quotation
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Quotation;
    /**
     * The StayDates
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JPSOAP_DateIntervalsGroupsStayDates
     */
    public $StayDates;
    /**
     * The CheckInDates
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JPSOAP_DateIntervalsGroupsCheckInDates
     */
    public $CheckInDates;
    /**
     * The CheckOutDates
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JPSOAP_DateIntervalsGroupsCheckInDates
     */
    public $CheckOutDates;
    /**
     * The BookingDates
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JPSOAP_DateIntervals
     */
    public $BookingDates;
    /**
     * The StayRestrictions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JPSOAP_StayRestrictions
     */
    public $StayRestrictions;
    /**
     * The BookingInAdvance
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JPSOAP_BookingInAdvance
     */
    public $BookingInAdvance;
    /**
     * The OccupancyRules
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JPSOAP_OccupanciesRules
     */
    public $OccupancyRules;
    /**
     * Constructor method for JPSOAP_ApplicationRules
     * @uses JPSOAP_ApplicationRules::setMustMatchAllStayDates()
     * @uses JPSOAP_ApplicationRules::setApplyAllStayIfMatchAnyDate()
     * @uses JPSOAP_ApplicationRules::setQuotation()
     * @uses JPSOAP_ApplicationRules::setStayDates()
     * @uses JPSOAP_ApplicationRules::setCheckInDates()
     * @uses JPSOAP_ApplicationRules::setCheckOutDates()
     * @uses JPSOAP_ApplicationRules::setBookingDates()
     * @uses JPSOAP_ApplicationRules::setStayRestrictions()
     * @uses JPSOAP_ApplicationRules::setBookingInAdvance()
     * @uses JPSOAP_ApplicationRules::setOccupancyRules()
     * @param bool $mustMatchAllStayDates
     * @param bool $applyAllStayIfMatchAnyDate
     * @param string $quotation
     * @param \StructType\JPSOAP_DateIntervalsGroupsStayDates $stayDates
     * @param \StructType\JPSOAP_DateIntervalsGroupsCheckInDates $checkInDates
     * @param \StructType\JPSOAP_DateIntervalsGroupsCheckInDates $checkOutDates
     * @param \StructType\JPSOAP_DateIntervals $bookingDates
     * @param \StructType\JPSOAP_StayRestrictions $stayRestrictions
     * @param \StructType\JPSOAP_BookingInAdvance $bookingInAdvance
     * @param \StructType\JPSOAP_OccupanciesRules $occupancyRules
     */
    public function __construct($mustMatchAllStayDates = null, $applyAllStayIfMatchAnyDate = null, $quotation = null, \StructType\JPSOAP_DateIntervalsGroupsStayDates $stayDates = null, \StructType\JPSOAP_DateIntervalsGroupsCheckInDates $checkInDates = null, \StructType\JPSOAP_DateIntervalsGroupsCheckInDates $checkOutDates = null, \StructType\JPSOAP_DateIntervals $bookingDates = null, \StructType\JPSOAP_StayRestrictions $stayRestrictions = null, \StructType\JPSOAP_BookingInAdvance $bookingInAdvance = null, \StructType\JPSOAP_OccupanciesRules $occupancyRules = null)
    {
        $this
            ->setMustMatchAllStayDates($mustMatchAllStayDates)
            ->setApplyAllStayIfMatchAnyDate($applyAllStayIfMatchAnyDate)
            ->setQuotation($quotation)
            ->setStayDates($stayDates)
            ->setCheckInDates($checkInDates)
            ->setCheckOutDates($checkOutDates)
            ->setBookingDates($bookingDates)
            ->setStayRestrictions($stayRestrictions)
            ->setBookingInAdvance($bookingInAdvance)
            ->setOccupancyRules($occupancyRules);
    }
    /**
     * Get MustMatchAllStayDates value
     * @return bool
     */
    public function getMustMatchAllStayDates()
    {
        return $this->MustMatchAllStayDates;
    }
    /**
     * Set MustMatchAllStayDates value
     * @param bool $mustMatchAllStayDates
     * @return \StructType\JPSOAP_ApplicationRules
     */
    public function setMustMatchAllStayDates($mustMatchAllStayDates = null)
    {
        // validation for constraint: boolean
        if (!is_null($mustMatchAllStayDates) && !is_bool($mustMatchAllStayDates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($mustMatchAllStayDates, true), gettype($mustMatchAllStayDates)), __LINE__);
        }
        $this->MustMatchAllStayDates = $mustMatchAllStayDates;
        return $this;
    }
    /**
     * Get ApplyAllStayIfMatchAnyDate value
     * @return bool
     */
    public function getApplyAllStayIfMatchAnyDate()
    {
        return $this->ApplyAllStayIfMatchAnyDate;
    }
    /**
     * Set ApplyAllStayIfMatchAnyDate value
     * @param bool $applyAllStayIfMatchAnyDate
     * @return \StructType\JPSOAP_ApplicationRules
     */
    public function setApplyAllStayIfMatchAnyDate($applyAllStayIfMatchAnyDate = null)
    {
        // validation for constraint: boolean
        if (!is_null($applyAllStayIfMatchAnyDate) && !is_bool($applyAllStayIfMatchAnyDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($applyAllStayIfMatchAnyDate, true), gettype($applyAllStayIfMatchAnyDate)), __LINE__);
        }
        $this->ApplyAllStayIfMatchAnyDate = $applyAllStayIfMatchAnyDate;
        return $this;
    }
    /**
     * Get Quotation value
     * @return string
     */
    public function getQuotation()
    {
        return $this->Quotation;
    }
    /**
     * Set Quotation value
     * @uses \EnumType\JPSOAP_ApplicationRuleQuotation::valueIsValid()
     * @uses \EnumType\JPSOAP_ApplicationRuleQuotation::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $quotation
     * @return \StructType\JPSOAP_ApplicationRules
     */
    public function setQuotation($quotation = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JPSOAP_ApplicationRuleQuotation::valueIsValid($quotation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JPSOAP_ApplicationRuleQuotation', is_array($quotation) ? implode(', ', $quotation) : var_export($quotation, true), implode(', ', \EnumType\JPSOAP_ApplicationRuleQuotation::getValidValues())), __LINE__);
        }
        $this->Quotation = $quotation;
        return $this;
    }
    /**
     * Get StayDates value
     * @return \StructType\JPSOAP_DateIntervalsGroupsStayDates|null
     */
    public function getStayDates()
    {
        return $this->StayDates;
    }
    /**
     * Set StayDates value
     * @param \StructType\JPSOAP_DateIntervalsGroupsStayDates $stayDates
     * @return \StructType\JPSOAP_ApplicationRules
     */
    public function setStayDates(\StructType\JPSOAP_DateIntervalsGroupsStayDates $stayDates = null)
    {
        $this->StayDates = $stayDates;
        return $this;
    }
    /**
     * Get CheckInDates value
     * @return \StructType\JPSOAP_DateIntervalsGroupsCheckInDates|null
     */
    public function getCheckInDates()
    {
        return $this->CheckInDates;
    }
    /**
     * Set CheckInDates value
     * @param \StructType\JPSOAP_DateIntervalsGroupsCheckInDates $checkInDates
     * @return \StructType\JPSOAP_ApplicationRules
     */
    public function setCheckInDates(\StructType\JPSOAP_DateIntervalsGroupsCheckInDates $checkInDates = null)
    {
        $this->CheckInDates = $checkInDates;
        return $this;
    }
    /**
     * Get CheckOutDates value
     * @return \StructType\JPSOAP_DateIntervalsGroupsCheckInDates|null
     */
    public function getCheckOutDates()
    {
        return $this->CheckOutDates;
    }
    /**
     * Set CheckOutDates value
     * @param \StructType\JPSOAP_DateIntervalsGroupsCheckInDates $checkOutDates
     * @return \StructType\JPSOAP_ApplicationRules
     */
    public function setCheckOutDates(\StructType\JPSOAP_DateIntervalsGroupsCheckInDates $checkOutDates = null)
    {
        $this->CheckOutDates = $checkOutDates;
        return $this;
    }
    /**
     * Get BookingDates value
     * @return \StructType\JPSOAP_DateIntervals|null
     */
    public function getBookingDates()
    {
        return $this->BookingDates;
    }
    /**
     * Set BookingDates value
     * @param \StructType\JPSOAP_DateIntervals $bookingDates
     * @return \StructType\JPSOAP_ApplicationRules
     */
    public function setBookingDates(\StructType\JPSOAP_DateIntervals $bookingDates = null)
    {
        $this->BookingDates = $bookingDates;
        return $this;
    }
    /**
     * Get StayRestrictions value
     * @return \StructType\JPSOAP_StayRestrictions|null
     */
    public function getStayRestrictions()
    {
        return $this->StayRestrictions;
    }
    /**
     * Set StayRestrictions value
     * @param \StructType\JPSOAP_StayRestrictions $stayRestrictions
     * @return \StructType\JPSOAP_ApplicationRules
     */
    public function setStayRestrictions(\StructType\JPSOAP_StayRestrictions $stayRestrictions = null)
    {
        $this->StayRestrictions = $stayRestrictions;
        return $this;
    }
    /**
     * Get BookingInAdvance value
     * @return \StructType\JPSOAP_BookingInAdvance|null
     */
    public function getBookingInAdvance()
    {
        return $this->BookingInAdvance;
    }
    /**
     * Set BookingInAdvance value
     * @param \StructType\JPSOAP_BookingInAdvance $bookingInAdvance
     * @return \StructType\JPSOAP_ApplicationRules
     */
    public function setBookingInAdvance(\StructType\JPSOAP_BookingInAdvance $bookingInAdvance = null)
    {
        $this->BookingInAdvance = $bookingInAdvance;
        return $this;
    }
    /**
     * Get OccupancyRules value
     * @return \StructType\JPSOAP_OccupanciesRules|null
     */
    public function getOccupancyRules()
    {
        return $this->OccupancyRules;
    }
    /**
     * Set OccupancyRules value
     * @param \StructType\JPSOAP_OccupanciesRules $occupancyRules
     * @return \StructType\JPSOAP_ApplicationRules
     */
    public function setOccupancyRules(\StructType\JPSOAP_OccupanciesRules $occupancyRules = null)
    {
        $this->OccupancyRules = $occupancyRules;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JPSOAP_ApplicationRules
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
