<?php

namespace EnumType;

/**
 * This class stands for JP_SegmentHotelType EnumType
 * @subpackage Enumerations
 */
class JP_SegmentHotelType
{
    /**
     * Constant for value 'VERIFIED'
     * @return string 'VERIFIED'
     */
    const VALUE_VERIFIED = 'VERIFIED';
    /**
     * Constant for value 'GREY'
     * @return string 'GREY'
     */
    const VALUE_GREY = 'GREY';
    /**
     * Constant for value 'NOHOTEL'
     * @return string 'NOHOTEL'
     */
    const VALUE_NOHOTEL = 'NOHOTEL';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_VERIFIED
     * @uses self::VALUE_GREY
     * @uses self::VALUE_NOHOTEL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_VERIFIED,
            self::VALUE_GREY,
            self::VALUE_NOHOTEL,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
