<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfJP_FlightLocator ArrayType
 * @subpackage Arrays
 */
class ArrayOfJP_FlightLocator extends AbstractStructArrayBase
{
    /**
     * The Reservation
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_FlightLocator[]
     */
    public $Reservation;
    /**
     * Constructor method for ArrayOfJP_FlightLocator
     * @uses ArrayOfJP_FlightLocator::setReservation()
     * @param \StructType\JP_FlightLocator[] $reservation
     */
    public function __construct(array $reservation = array())
    {
        $this
            ->setReservation($reservation);
    }
    /**
     * Get Reservation value
     * @return \StructType\JP_FlightLocator[]|null
     */
    public function getReservation()
    {
        return $this->Reservation;
    }
    /**
     * This method is responsible for validating the values passed to the setReservation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReservation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReservationForArrayConstraintsFromSetReservation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfJP_FlightLocatorReservationItem) {
            // validation for constraint: itemType
            if (!$arrayOfJP_FlightLocatorReservationItem instanceof \StructType\JP_FlightLocator) {
                $invalidValues[] = is_object($arrayOfJP_FlightLocatorReservationItem) ? get_class($arrayOfJP_FlightLocatorReservationItem) : sprintf('%s(%s)', gettype($arrayOfJP_FlightLocatorReservationItem), var_export($arrayOfJP_FlightLocatorReservationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Reservation property can only contain items of type \StructType\JP_FlightLocator, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Reservation value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_FlightLocator[] $reservation
     * @return \ArrayType\ArrayOfJP_FlightLocator
     */
    public function setReservation(array $reservation = array())
    {
        // validation for constraint: array
        if ('' !== ($reservationArrayErrorMessage = self::validateReservationForArrayConstraintsFromSetReservation($reservation))) {
            throw new \InvalidArgumentException($reservationArrayErrorMessage, __LINE__);
        }
        $this->Reservation = $reservation;
        return $this;
    }
    /**
     * Add item to Reservation value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_FlightLocator $item
     * @return \ArrayType\ArrayOfJP_FlightLocator
     */
    public function addToReservation(\StructType\JP_FlightLocator $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_FlightLocator) {
            throw new \InvalidArgumentException(sprintf('The Reservation property can only contain items of type \StructType\JP_FlightLocator, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Reservation[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\JP_FlightLocator|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\JP_FlightLocator|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\JP_FlightLocator|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\JP_FlightLocator|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\JP_FlightLocator|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Reservation
     */
    public function getAttributeName()
    {
        return 'Reservation';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfJP_FlightLocator
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
