<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfJP_CustomerIDElement ArrayType
 * @subpackage Arrays
 */
class ArrayOfJP_CustomerIDElement extends AbstractStructArrayBase
{
    /**
     * The Account
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_CustomerIDElement[]
     */
    public $Account;
    /**
     * Constructor method for ArrayOfJP_CustomerIDElement
     * @uses ArrayOfJP_CustomerIDElement::setAccount()
     * @param \StructType\JP_CustomerIDElement[] $account
     */
    public function __construct(array $account = array())
    {
        $this
            ->setAccount($account);
    }
    /**
     * Get Account value
     * @return \StructType\JP_CustomerIDElement[]|null
     */
    public function getAccount()
    {
        return $this->Account;
    }
    /**
     * This method is responsible for validating the values passed to the setAccount method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAccount method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAccountForArrayConstraintsFromSetAccount(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfJP_CustomerIDElementAccountItem) {
            // validation for constraint: itemType
            if (!$arrayOfJP_CustomerIDElementAccountItem instanceof \StructType\JP_CustomerIDElement) {
                $invalidValues[] = is_object($arrayOfJP_CustomerIDElementAccountItem) ? get_class($arrayOfJP_CustomerIDElementAccountItem) : sprintf('%s(%s)', gettype($arrayOfJP_CustomerIDElementAccountItem), var_export($arrayOfJP_CustomerIDElementAccountItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Account property can only contain items of type \StructType\JP_CustomerIDElement, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Account value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_CustomerIDElement[] $account
     * @return \ArrayType\ArrayOfJP_CustomerIDElement
     */
    public function setAccount(array $account = array())
    {
        // validation for constraint: array
        if ('' !== ($accountArrayErrorMessage = self::validateAccountForArrayConstraintsFromSetAccount($account))) {
            throw new \InvalidArgumentException($accountArrayErrorMessage, __LINE__);
        }
        $this->Account = $account;
        return $this;
    }
    /**
     * Add item to Account value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_CustomerIDElement $item
     * @return \ArrayType\ArrayOfJP_CustomerIDElement
     */
    public function addToAccount(\StructType\JP_CustomerIDElement $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_CustomerIDElement) {
            throw new \InvalidArgumentException(sprintf('The Account property can only contain items of type \StructType\JP_CustomerIDElement, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Account[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\JP_CustomerIDElement|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\JP_CustomerIDElement|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\JP_CustomerIDElement|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\JP_CustomerIDElement|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\JP_CustomerIDElement|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Account
     */
    public function getAttributeName()
    {
        return 'Account';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfJP_CustomerIDElement
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
