<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfJPSOAP_Allotment ArrayType
 * @subpackage Arrays
 */
class ArrayOfJPSOAP_Allotment extends AbstractStructArrayBase
{
    /**
     * The Allotment
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JPSOAP_Allotment[]
     */
    public $Allotment;
    /**
     * Constructor method for ArrayOfJPSOAP_Allotment
     * @uses ArrayOfJPSOAP_Allotment::setAllotment()
     * @param \StructType\JPSOAP_Allotment[] $allotment
     */
    public function __construct(array $allotment = array())
    {
        $this
            ->setAllotment($allotment);
    }
    /**
     * Get Allotment value
     * @return \StructType\JPSOAP_Allotment[]|null
     */
    public function getAllotment()
    {
        return $this->Allotment;
    }
    /**
     * This method is responsible for validating the values passed to the setAllotment method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAllotment method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAllotmentForArrayConstraintsFromSetAllotment(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfJPSOAP_AllotmentAllotmentItem) {
            // validation for constraint: itemType
            if (!$arrayOfJPSOAP_AllotmentAllotmentItem instanceof \StructType\JPSOAP_Allotment) {
                $invalidValues[] = is_object($arrayOfJPSOAP_AllotmentAllotmentItem) ? get_class($arrayOfJPSOAP_AllotmentAllotmentItem) : sprintf('%s(%s)', gettype($arrayOfJPSOAP_AllotmentAllotmentItem), var_export($arrayOfJPSOAP_AllotmentAllotmentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Allotment property can only contain items of type \StructType\JPSOAP_Allotment, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Allotment value
     * @throws \InvalidArgumentException
     * @param \StructType\JPSOAP_Allotment[] $allotment
     * @return \ArrayType\ArrayOfJPSOAP_Allotment
     */
    public function setAllotment(array $allotment = array())
    {
        // validation for constraint: array
        if ('' !== ($allotmentArrayErrorMessage = self::validateAllotmentForArrayConstraintsFromSetAllotment($allotment))) {
            throw new \InvalidArgumentException($allotmentArrayErrorMessage, __LINE__);
        }
        $this->Allotment = $allotment;
        return $this;
    }
    /**
     * Add item to Allotment value
     * @throws \InvalidArgumentException
     * @param \StructType\JPSOAP_Allotment $item
     * @return \ArrayType\ArrayOfJPSOAP_Allotment
     */
    public function addToAllotment(\StructType\JPSOAP_Allotment $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JPSOAP_Allotment) {
            throw new \InvalidArgumentException(sprintf('The Allotment property can only contain items of type \StructType\JPSOAP_Allotment, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Allotment[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\JPSOAP_Allotment|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\JPSOAP_Allotment|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\JPSOAP_Allotment|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\JPSOAP_Allotment|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\JPSOAP_Allotment|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Allotment
     */
    public function getAttributeName()
    {
        return 'Allotment';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfJPSOAP_Allotment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
