<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_RentacarOption StructType
 * @subpackage Structs
 */
class JP_RentacarOption extends AbstractStructBase
{
    /**
     * The RentacarInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_RentacarInfo
     */
    public $RentacarInfo;
    /**
     * The Prices
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_Price
     */
    public $Prices;
    /**
     * The ContractInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_RentacarSaleContract
     */
    public $ContractInfo;
    /**
     * The AdditionalElements
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_RentacarAdditionalElements
     */
    public $AdditionalElements;
    /**
     * The PickUpCode
     * @var string
     */
    public $PickUpCode;
    /**
     * The DropOffCode
     * @var string
     */
    public $DropOffCode;
    /**
     * The AcrissCode
     * @var string
     */
    public $AcrissCode;
    /**
     * The RatePlanCode
     * @var string
     */
    public $RatePlanCode;
    /**
     * The Status
     * @var string
     */
    public $Status;
    /**
     * The PaymentOffice
     * @var bool
     */
    public $PaymentOffice;
    /**
     * Constructor method for JP_RentacarOption
     * @uses JP_RentacarOption::setRentacarInfo()
     * @uses JP_RentacarOption::setPrices()
     * @uses JP_RentacarOption::setContractInfo()
     * @uses JP_RentacarOption::setAdditionalElements()
     * @uses JP_RentacarOption::setPickUpCode()
     * @uses JP_RentacarOption::setDropOffCode()
     * @uses JP_RentacarOption::setAcrissCode()
     * @uses JP_RentacarOption::setRatePlanCode()
     * @uses JP_RentacarOption::setStatus()
     * @uses JP_RentacarOption::setPaymentOffice()
     * @param \StructType\JP_RentacarInfo $rentacarInfo
     * @param \ArrayType\ArrayOfJP_Price $prices
     * @param \StructType\JP_RentacarSaleContract $contractInfo
     * @param \StructType\JP_RentacarAdditionalElements $additionalElements
     * @param string $pickUpCode
     * @param string $dropOffCode
     * @param string $acrissCode
     * @param string $ratePlanCode
     * @param string $status
     * @param bool $paymentOffice
     */
    public function __construct(\StructType\JP_RentacarInfo $rentacarInfo = null, \ArrayType\ArrayOfJP_Price $prices = null, \StructType\JP_RentacarSaleContract $contractInfo = null, \StructType\JP_RentacarAdditionalElements $additionalElements = null, $pickUpCode = null, $dropOffCode = null, $acrissCode = null, $ratePlanCode = null, $status = null, $paymentOffice = null)
    {
        $this
            ->setRentacarInfo($rentacarInfo)
            ->setPrices($prices)
            ->setContractInfo($contractInfo)
            ->setAdditionalElements($additionalElements)
            ->setPickUpCode($pickUpCode)
            ->setDropOffCode($dropOffCode)
            ->setAcrissCode($acrissCode)
            ->setRatePlanCode($ratePlanCode)
            ->setStatus($status)
            ->setPaymentOffice($paymentOffice);
    }
    /**
     * Get RentacarInfo value
     * @return \StructType\JP_RentacarInfo|null
     */
    public function getRentacarInfo()
    {
        return $this->RentacarInfo;
    }
    /**
     * Set RentacarInfo value
     * @param \StructType\JP_RentacarInfo $rentacarInfo
     * @return \StructType\JP_RentacarOption
     */
    public function setRentacarInfo(\StructType\JP_RentacarInfo $rentacarInfo = null)
    {
        $this->RentacarInfo = $rentacarInfo;
        return $this;
    }
    /**
     * Get Prices value
     * @return \ArrayType\ArrayOfJP_Price|null
     */
    public function getPrices()
    {
        return $this->Prices;
    }
    /**
     * Set Prices value
     * @param \ArrayType\ArrayOfJP_Price $prices
     * @return \StructType\JP_RentacarOption
     */
    public function setPrices(\ArrayType\ArrayOfJP_Price $prices = null)
    {
        $this->Prices = $prices;
        return $this;
    }
    /**
     * Get ContractInfo value
     * @return \StructType\JP_RentacarSaleContract|null
     */
    public function getContractInfo()
    {
        return $this->ContractInfo;
    }
    /**
     * Set ContractInfo value
     * @param \StructType\JP_RentacarSaleContract $contractInfo
     * @return \StructType\JP_RentacarOption
     */
    public function setContractInfo(\StructType\JP_RentacarSaleContract $contractInfo = null)
    {
        $this->ContractInfo = $contractInfo;
        return $this;
    }
    /**
     * Get AdditionalElements value
     * @return \StructType\JP_RentacarAdditionalElements|null
     */
    public function getAdditionalElements()
    {
        return $this->AdditionalElements;
    }
    /**
     * Set AdditionalElements value
     * @param \StructType\JP_RentacarAdditionalElements $additionalElements
     * @return \StructType\JP_RentacarOption
     */
    public function setAdditionalElements(\StructType\JP_RentacarAdditionalElements $additionalElements = null)
    {
        $this->AdditionalElements = $additionalElements;
        return $this;
    }
    /**
     * Get PickUpCode value
     * @return string|null
     */
    public function getPickUpCode()
    {
        return $this->PickUpCode;
    }
    /**
     * Set PickUpCode value
     * @param string $pickUpCode
     * @return \StructType\JP_RentacarOption
     */
    public function setPickUpCode($pickUpCode = null)
    {
        // validation for constraint: string
        if (!is_null($pickUpCode) && !is_string($pickUpCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pickUpCode, true), gettype($pickUpCode)), __LINE__);
        }
        $this->PickUpCode = $pickUpCode;
        return $this;
    }
    /**
     * Get DropOffCode value
     * @return string|null
     */
    public function getDropOffCode()
    {
        return $this->DropOffCode;
    }
    /**
     * Set DropOffCode value
     * @param string $dropOffCode
     * @return \StructType\JP_RentacarOption
     */
    public function setDropOffCode($dropOffCode = null)
    {
        // validation for constraint: string
        if (!is_null($dropOffCode) && !is_string($dropOffCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dropOffCode, true), gettype($dropOffCode)), __LINE__);
        }
        $this->DropOffCode = $dropOffCode;
        return $this;
    }
    /**
     * Get AcrissCode value
     * @return string|null
     */
    public function getAcrissCode()
    {
        return $this->AcrissCode;
    }
    /**
     * Set AcrissCode value
     * @param string $acrissCode
     * @return \StructType\JP_RentacarOption
     */
    public function setAcrissCode($acrissCode = null)
    {
        // validation for constraint: string
        if (!is_null($acrissCode) && !is_string($acrissCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($acrissCode, true), gettype($acrissCode)), __LINE__);
        }
        $this->AcrissCode = $acrissCode;
        return $this;
    }
    /**
     * Get RatePlanCode value
     * @return string|null
     */
    public function getRatePlanCode()
    {
        return $this->RatePlanCode;
    }
    /**
     * Set RatePlanCode value
     * @param string $ratePlanCode
     * @return \StructType\JP_RentacarOption
     */
    public function setRatePlanCode($ratePlanCode = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanCode) && !is_string($ratePlanCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratePlanCode, true), gettype($ratePlanCode)), __LINE__);
        }
        $this->RatePlanCode = $ratePlanCode;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \EnumType\JP_AvailStatus::valueIsValid()
     * @uses \EnumType\JP_AvailStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\JP_RentacarOption
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JP_AvailStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JP_AvailStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \EnumType\JP_AvailStatus::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get PaymentOffice value
     * @return bool|null
     */
    public function getPaymentOffice()
    {
        return $this->PaymentOffice;
    }
    /**
     * Set PaymentOffice value
     * @param bool $paymentOffice
     * @return \StructType\JP_RentacarOption
     */
    public function setPaymentOffice($paymentOffice = null)
    {
        // validation for constraint: boolean
        if (!is_null($paymentOffice) && !is_bool($paymentOffice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($paymentOffice, true), gettype($paymentOffice)), __LINE__);
        }
        $this->PaymentOffice = $paymentOffice;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_RentacarOption
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
