<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_Paxes StructType
 * @subpackage Structs
 */
class JP_Paxes extends AbstractStructBase
{
    /**
     * The Pax
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_Pax[]
     */
    public $Pax;
    /**
     * The AdultsFree
     * @var int
     */
    public $AdultsFree;
    /**
     * The ChildrenFree
     * @var int
     */
    public $ChildrenFree;
    /**
     * Constructor method for JP_Paxes
     * @uses JP_Paxes::setPax()
     * @uses JP_Paxes::setAdultsFree()
     * @uses JP_Paxes::setChildrenFree()
     * @param \StructType\JP_Pax[] $pax
     * @param int $adultsFree
     * @param int $childrenFree
     */
    public function __construct(array $pax = array(), $adultsFree = null, $childrenFree = null)
    {
        $this
            ->setPax($pax)
            ->setAdultsFree($adultsFree)
            ->setChildrenFree($childrenFree);
    }
    /**
     * Get Pax value
     * @return \StructType\JP_Pax[]|null
     */
    public function getPax()
    {
        return $this->Pax;
    }
    /**
     * This method is responsible for validating the values passed to the setPax method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPax method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaxForArrayConstraintsFromSetPax(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $jP_PaxesPaxItem) {
            // validation for constraint: itemType
            if (!$jP_PaxesPaxItem instanceof \StructType\JP_Pax) {
                $invalidValues[] = is_object($jP_PaxesPaxItem) ? get_class($jP_PaxesPaxItem) : sprintf('%s(%s)', gettype($jP_PaxesPaxItem), var_export($jP_PaxesPaxItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Pax property can only contain items of type \StructType\JP_Pax, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Pax value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_Pax[] $pax
     * @return \StructType\JP_Paxes
     */
    public function setPax(array $pax = array())
    {
        // validation for constraint: array
        if ('' !== ($paxArrayErrorMessage = self::validatePaxForArrayConstraintsFromSetPax($pax))) {
            throw new \InvalidArgumentException($paxArrayErrorMessage, __LINE__);
        }
        $this->Pax = $pax;
        return $this;
    }
    /**
     * Add item to Pax value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_Pax $item
     * @return \StructType\JP_Paxes
     */
    public function addToPax(\StructType\JP_Pax $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_Pax) {
            throw new \InvalidArgumentException(sprintf('The Pax property can only contain items of type \StructType\JP_Pax, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Pax[] = $item;
        return $this;
    }
    /**
     * Get AdultsFree value
     * @return int|null
     */
    public function getAdultsFree()
    {
        return $this->AdultsFree;
    }
    /**
     * Set AdultsFree value
     * @param int $adultsFree
     * @return \StructType\JP_Paxes
     */
    public function setAdultsFree($adultsFree = null)
    {
        // validation for constraint: int
        if (!is_null($adultsFree) && !(is_int($adultsFree) || ctype_digit($adultsFree))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($adultsFree, true), gettype($adultsFree)), __LINE__);
        }
        $this->AdultsFree = $adultsFree;
        return $this;
    }
    /**
     * Get ChildrenFree value
     * @return int|null
     */
    public function getChildrenFree()
    {
        return $this->ChildrenFree;
    }
    /**
     * Set ChildrenFree value
     * @param int $childrenFree
     * @return \StructType\JP_Paxes
     */
    public function setChildrenFree($childrenFree = null)
    {
        // validation for constraint: int
        if (!is_null($childrenFree) && !(is_int($childrenFree) || ctype_digit($childrenFree))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($childrenFree, true), gettype($childrenFree)), __LINE__);
        }
        $this->ChildrenFree = $childrenFree;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_Paxes
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
