<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_PackageInsurance StructType
 * @subpackage Structs
 */
class JP_PackageInsurance extends AbstractStructBase
{
    /**
     * The Start
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Start;
    /**
     * The End
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $End;
    /**
     * The InsuranceInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_InsuranceInfo
     */
    public $InsuranceInfo;
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * The ICode
     * @var string
     */
    public $ICode;
    /**
     * The SearchMore
     * @var bool
     */
    public $SearchMore;
    /**
     * The Order
     * @var int
     */
    public $Order;
    /**
     * Constructor method for JP_PackageInsurance
     * @uses JP_PackageInsurance::setStart()
     * @uses JP_PackageInsurance::setEnd()
     * @uses JP_PackageInsurance::setInsuranceInfo()
     * @uses JP_PackageInsurance::setCode()
     * @uses JP_PackageInsurance::setICode()
     * @uses JP_PackageInsurance::setSearchMore()
     * @uses JP_PackageInsurance::setOrder()
     * @param string $start
     * @param string $end
     * @param \StructType\JP_InsuranceInfo $insuranceInfo
     * @param string $code
     * @param string $iCode
     * @param bool $searchMore
     * @param int $order
     */
    public function __construct($start = null, $end = null, \StructType\JP_InsuranceInfo $insuranceInfo = null, $code = null, $iCode = null, $searchMore = null, $order = null)
    {
        $this
            ->setStart($start)
            ->setEnd($end)
            ->setInsuranceInfo($insuranceInfo)
            ->setCode($code)
            ->setICode($iCode)
            ->setSearchMore($searchMore)
            ->setOrder($order);
    }
    /**
     * Get Start value
     * @return string
     */
    public function getStart()
    {
        return $this->Start;
    }
    /**
     * Set Start value
     * @param string $start
     * @return \StructType\JP_PackageInsurance
     */
    public function setStart($start = null)
    {
        // validation for constraint: string
        if (!is_null($start) && !is_string($start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($start, true), gettype($start)), __LINE__);
        }
        $this->Start = $start;
        return $this;
    }
    /**
     * Get End value
     * @return string
     */
    public function getEnd()
    {
        return $this->End;
    }
    /**
     * Set End value
     * @param string $end
     * @return \StructType\JP_PackageInsurance
     */
    public function setEnd($end = null)
    {
        // validation for constraint: string
        if (!is_null($end) && !is_string($end)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($end, true), gettype($end)), __LINE__);
        }
        $this->End = $end;
        return $this;
    }
    /**
     * Get InsuranceInfo value
     * @return \StructType\JP_InsuranceInfo|null
     */
    public function getInsuranceInfo()
    {
        return $this->InsuranceInfo;
    }
    /**
     * Set InsuranceInfo value
     * @param \StructType\JP_InsuranceInfo $insuranceInfo
     * @return \StructType\JP_PackageInsurance
     */
    public function setInsuranceInfo(\StructType\JP_InsuranceInfo $insuranceInfo = null)
    {
        $this->InsuranceInfo = $insuranceInfo;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\JP_PackageInsurance
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get ICode value
     * @return string|null
     */
    public function getICode()
    {
        return $this->ICode;
    }
    /**
     * Set ICode value
     * @param string $iCode
     * @return \StructType\JP_PackageInsurance
     */
    public function setICode($iCode = null)
    {
        // validation for constraint: string
        if (!is_null($iCode) && !is_string($iCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iCode, true), gettype($iCode)), __LINE__);
        }
        $this->ICode = $iCode;
        return $this;
    }
    /**
     * Get SearchMore value
     * @return bool|null
     */
    public function getSearchMore()
    {
        return $this->SearchMore;
    }
    /**
     * Set SearchMore value
     * @param bool $searchMore
     * @return \StructType\JP_PackageInsurance
     */
    public function setSearchMore($searchMore = null)
    {
        // validation for constraint: boolean
        if (!is_null($searchMore) && !is_bool($searchMore)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($searchMore, true), gettype($searchMore)), __LINE__);
        }
        $this->SearchMore = $searchMore;
        return $this;
    }
    /**
     * Get Order value
     * @return int|null
     */
    public function getOrder()
    {
        return $this->Order;
    }
    /**
     * Set Order value
     * @param int $order
     * @return \StructType\JP_PackageInsurance
     */
    public function setOrder($order = null)
    {
        // validation for constraint: int
        if (!is_null($order) && !(is_int($order) || ctype_digit($order))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($order, true), gettype($order)), __LINE__);
        }
        $this->Order = $order;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_PackageInsurance
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
